/* 
 * Starter file for CS 208 assignment: Queues in C
 * Adapted by Aaron Bauer and then Jeff Ondich and Tanya Amert
 * from a lab developed at CMU by R. E. Bryant, 2017-2018.
 */

/*
 * This program implements a queue supporting both FIFO and LIFO
 * operations.
 *
 * It uses a singly-linked list to represent the set of queue elements.
 */

#include <stdbool.h>

/************** Data structure declarations ****************/

/* Linked list element (you shouldn't need to change this) */
typedef struct list_ele {
    /* Pointer to array holding string.
       This array needs to be explicitly allocated and freed. */
    char *value;

    /* Pointer to next element in the linked list. */
    struct list_ele *next;
} list_ele_t;

/* Queue structure */
typedef struct {
    list_ele_t *head;  /* linked list of elements */

    /*
     * You will need to add more fields to this structure
     * to efficiently implement q_size and q_insert_tail.
     */
} queue_t;

/************** Operations on queue ************************/

/*
 * Creates empty queue.
 * Returns NULL if could not allocate space.
 */
queue_t *q_new();

/*
 * Frees ALL storage used by queue.
 * Has no effect if q is NULL.
 */
void q_free(queue_t *q);

/*
 * Attempts to insert element at head of queue.
 * Returns true if successful.
 * Returns false if q is NULL or could not allocate space.
 * Argument s points to the string to be stored.
 * The function must explicitly allocate space and copy the string into it.
 */
bool q_insert_head(queue_t *q, char *s);

/*
 * Attempts to insert element at tail of queue.
 * Returns true if successful.
 * Returns false if q is NULL or could not allocate space.
 * Argument s points to the string to be stored.
 * The function must explicitly allocate space and copy the string into it.
 */
bool q_insert_tail(queue_t *q, char *s);

/*
 * Attempts to remove element from head of queue.
 * Returns true if successful.
 * Returns false if queue is NULL or empty.
 * If sp is non-NULL and an element is removed, copy the removed string to *sp
 * (up to a maximum of bufsize-1 characters, plus a null terminator).
 * The space used by the list element and the string should be freed.
 */
bool q_remove_head(queue_t *q, char *sp, size_t bufsize);

/*
 * Returns number of elements in queue.
 * Returns 0 if q is NULL or empty.
 */
int q_size(queue_t *q);

/*
 * Reverses elements in queue.
 * Has no effect if q is NULL or empty.
 * This function should not allocate or free any list elements
 * (e.g., by calling q_insert_head, q_insert_tail, or q_remove_head).
 * It should rearrange the existing ones.
 */
void q_reverse(queue_t *q);
