/*
 * Starter file for CS 208 assignment: Queues in C
 * Adapted by Aaron Bauer and then Jeff Ondich and Tanya Amert
 * from a lab developed at CMU by R. E. Bryant, 2017-2018.
 */

/*
 * This program implements a queue supporting both FIFO and LIFO
 * operations.
 *
 * It uses a singly-linked list to represent the set of queue elements.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "harness.h"
#include "queue.h"

/*
 * Creates empty queue.
 * Returns NULL if could not allocate space.
 */
queue_t *q_new()
{
    // Allocate space for a new queue
    queue_t *q =  malloc(sizeof(queue_t));

    // TODO: check if malloc returned NULL (this means space could not be allocated)

    // Set the head of the queue to NULL (it's empty) and return
    // the address of the queue
    q->head = NULL;
    return q;
}

/*
 * Frees ALL storage used by queue.
 * Has no effect if q is NULL.
 */
void q_free(queue_t *q)
{
    // TODO: no effect if q is NULL

    // TODO: free the queue notes; you'll want to loop through the
    // list nodes until the next pointer is NULL, starting at the head,
    // freeing each node and its value.  Make sure to account for an
    // empty list (head is NULL).

    // Free queue structure itself
    free(q);
}

/*
 * Attempts to insert element at head of queue.
 * Returns true if successful.
 * Returns false if q is NULL or could not allocate space.
 * Argument s points to the string to be stored.
 * The function must explicitly allocate space and copy the string into it.
 */
bool q_insert_head(queue_t *q, char *s)
{
    list_ele_t *new_node;

    // TODO: check if q is NULL; what should you do if so?

    // Allocate space on the heap for a new node
    new_node = malloc(sizeof(list_ele_t));

    // TODO: return false if malloc returns NULL (i.e., couldn't
    // allocate space)

    // TODO: allocate space for copying the string s

    // TODO: if this second malloc call returns NULL, you need to free
    // new_node before returning

    // TODO: copy s to the value of the new node

    // TODO: Hey wait a second....aren't we also gonna do q_insert_tail?
    // Should we maybe write a utility function to allocate and return a
    // new node so we can reuse it there?
    
    // Connect the new node to the front of the queue
    new_node->next = q->head;
    q->head = new_node;

    // TODO: if the list was empty, the tail might also need updating, however it
    // is you're implementing the notion of tail

    return true;
}


/*
 * Attempts to insert element at tail of queue.
 * Returns true if successful.
 * Returns false if q is NULL or could not allocate space.
 * Argument s points to the string to be stored.
 * The function must explicitly allocate space and copy the string into it.
 */
bool q_insert_tail(queue_t *q, char *s)
{
    // TODO: implement in similar fashion to q_insert_head

    // You'll certainly want to add a field to queue_t so we can access
    // the tail efficiently

    // TODO: if the list was empty, the head might also need updating

    return false;
}

/*
 * Attempts to remove element from head of queue.
 * Returns true if successful.
 * Returns false if queue is NULL or empty.
 * If sp is non-NULL and an element is removed, copy the removed string to *sp
 * (up to a maximum of bufsize-1 characters, plus a null terminator).
 * The space used by the list element and the string should be freed.
 */
bool q_remove_head(queue_t *q, char *sp, size_t bufsize)
{
    // TODO: check if q is NULL or empty

    // TODO: if sp is not NULL, copy value at the head to sp

    // Use strncpy (http://www.cplusplus.com/reference/cstring/strncpy/);
    // bufsize is the number of characters already allocated for sp

    // TODO: things to think about:
    //    - what should happen if q->head->value is longer than bufsize?
    //    - what should happen if bufsize == 0?
    //    - under what conditions will strncpy copy the \0 character
    //        into sp, and when will it fail to do so (so you'll have
    //        to insert a \0 manually)?

    // TODO: update q->head to remove the current head from the queue
    q->head = q->head->next;

    // TODO: if the last list element was removed, the tail might need updating

    // TODO: hey, did you forget to free the removed list element?

    return true;
}

/*
 * Returns number of elements in queue.
 * Returns 0 if q is NULL or empty.
 */
int q_size(queue_t *q)
{
    // TODO: what if q == NULL or q->head == NULL?

    // If you add a field to queue_t to keep track of the number of
    // nodes in the queue, then this function is fast-running and
    // easy to write, but it also means you have to be very careful
    // about keeping track of the number of nodes elsewhere in your code.

    // At first, maybe just have this function simply count elements
    // until you hit NULL...

    return 0;
}

/*
 * Reverses elements in queue.
 * Has no effect if q is NULL or empty.
 * This function should not allocate or free any list elements
 * (e.g., by calling q_insert_head, q_insert_tail, or q_remove_head).
 * It should rearrange the existing ones.
 */
void q_reverse(queue_t *q)
{
    // TODO: good luck--this is fun when it works!
}
