#ifndef __SS_H__
#define __SS_H__

///////////////////////////////////////////////////////////////////////////
// Useful #defines -- make sure to understand these!                     //
///////////////////////////////////////////////////////////////////////////

// Optionally print debugging statements
#define SS_DEBUG 1

// For Proficiency, just allocate an array big enough
// to hold MAX_STRINGS strings
#define SS_MAX_STRINGS 100

// Use Proficiency or Mastery functions (uncomment #define to test mastery)
// #define SS_MASTERY

///////////////////////////////////////////////////////////////////////////
// Function to define: Proficiency                                       //
///////////////////////////////////////////////////////////////////////////

/*
 * Splits the given string by the given delimiter.  Stores the substrings
 * in the char * array given by substrings, and returns the number of
 * substrings found.
 */
int split_string(char *s, char delim, char **substrings);

///////////////////////////////////////////////////////////////////////////
// Functions to define: Mastery                                          //
///////////////////////////////////////////////////////////////////////////

/*
 * Counts the number of delim-separated substrings in s, and returns
 * that count.
 */
int count_substrings(char *s, char delim);

/*
 * Splits the given string by the given delimiter.  Returns a NULL-terminated
 * array of strings (char *), and stores the number of substrings in num_elts.
 */
char ** build_substrings(char *s, char delim, int *num_elts);

#endif // __SS_H__