/*
    main.c

    Jeff Ondich, 19 January 2022
    Updated September, 2023
    Updated by Tanya Amert August, 2024

    This main() is intended to illustrate one simple approach to writing
    your own testing infrastructure. A main program like this can
    be combined with a Makefile and input/expected-output files.
    Starter versions of Makefile and input/expected-output files are
    included in this bits-package directory.

    Regardless of whether you build on this testing infrastructure or
    start from scratch, you need some mechanism for testing your functions.
    Good luck and have fun!
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include "bits.h"

int main(int argc, char *argv[])
{
    // Check usage
    if (argc < 3)
    {
        fprintf(stderr, "Usage: %s action [arguments...]\n", argv[0]);
        fprintf(stderr, "  where action can be to_lower, to_upper,...\n");
        fprintf(stderr, "  and arguments are appropriate to the specific action.\n");
        return 1;
    }

    // Are we testing to_lower?
    if (strcmp(argv[1], "to_lower") == 0) {
        // Copy the second command-line argument (after to_lower) into
        // a C-string called buffer, which we'll provide to to_lower
        char *buffer = malloc(strlen(argv[2]) + 1);
        if (buffer != NULL)
        {
            strcpy(buffer, argv[2]);
            to_lower(buffer);
            printf("%s\n", buffer);
            free(buffer); // make sure to clean it up!
        }
    }

    // If not, maybe we're testing to_upper...
    else if (strcmp(argv[1], "to_upper") == 0)
    {
        // Copy the second command-line argument (after to_upper) into
        // a C-string called buffer, which we'll provide to to_upper
        char *buffer = malloc(strlen(argv[2]) + 1);
        if (buffer != NULL)
        {
            strcpy(buffer, argv[2]);
            to_upper(buffer);
            printf("%s\n", buffer);
            free(buffer); // make sure to clean it up!
        }
    }

    // etc.

    return 0;
}
