import kotlin.collections.emptyList
import java.io.File

class IMDBGraph {

    /***************** Constructor (plus helper method) *****************/

    // Our graph is represented by a pair of maps
    val performersToMovies = HashMap<String, MutableList<String>>()
    val moviesToPerformers = HashMap<String, MutableList<String>>()

    // These two maps just connect performer ID to name and movie ID to name; it
    // might make playing around with the data more pleasant to have access to them
    val movieIdsToTitles = HashMap<String, String>()
    val performerIdsToNames = HashMap<String, String>()

    // In the constructor, read in all of the data from the .tsv files
    init {
        // Read in performer IDs and names
        var reader = File("src/main/resources/performer-names.tsv").bufferedReader()
        while (reader.ready()) {
            val (nameid, name) = reader.readLine().split("\t")
            performerIdsToNames[nameid] = name
        }
        reader.close()

        // Read in titles
        println("Reading titles")
        reader = File("src/main/resources/movie-titles.tsv").bufferedReader()
        while (reader.ready()) {
            val (titleid, title) = reader.readLine().split("\t")
            movieIdsToTitles[titleid] = title
        }
        reader.close()

        // Read in actual performances (a performer appearing in a movie)
        reader = File("src/main/resources/performances.tsv").bufferedReader()
        while (reader.ready()) {
            val (titleid, nameid) = reader.readLine().split("\t")
            addEntry(nameid, titleid)
        }
        reader.close()
    }

    /* This function adds a performer ID and a movie title ID to both maps. */
    fun addEntry(performerId: String, movieId: String) {
        var titles = performersToMovies[performerId]
        if (titles == null) {
            titles = mutableListOf<String>()
            performersToMovies[performerId] = titles
        }
        titles.add(movieId)

        var names = moviesToPerformers[movieId]
        if (names == null) {
            names = mutableListOf()
            moviesToPerformers[movieId] = names
        }
        names.add(performerId)
    }
    
    /***************** Part A: Find connected performers *****************/

    /*
        TODO: describe this function
     */
    fun connectedPerformers(performerId: String, maxDistance: Int): Set<String> {
        // TODO: Part A
        return setOf<String>()
    }
    
    /***************** Part B: Find a path between performers *****************/

    /* This data class represents a performer-movie pair. */
    data class Connection(val performerId: String, val movieId: String)

    /* This function returns a list of connections from the startPerformer to
       the endPerformer.

       For example, consider a possible shortest path from Jack Nicholson to
       Elizabeth Olsen:

       nm0000197 Jack Nicholson
         tt0082934 The Postman Always Rings Twice
       nm0001448 Jessica Lange
         tt0409379 In Secret
       nm0647634 Elizabeth Olsen

       If this function were called with nm0000197 and nm0647634, the return value
       could be this list of Connections:
       [Connection(nm0000197, tt0082934), Connection(nm0001448, tt0409379)]

       (It is possible the code might find a different set of connections between
       the two performers, but the length must be the same as the above, as the
       above is a shortest path.)

       The endPerformer is not included in the connections returned.

       If there is no connection between the two, return an empty list.
     */
    fun shortestPath(startPerformer: String, endPerformer: String): List<Connection> {
        // TODO: Part B
        return listOf<Connection>()
    }
}
