/*
 * Author: YOUR NAME HERE
 *
 * Collaboration statement: TODO
 */

/**
 * WordCountTree class contains word counts within a provided series of strings.
 * Each node of the WordCountTree (WCT) contains a count. The children of a node
 * are all of the characters that could come after the node's character to
 * represent a word.
 */
class WordCountTree {
    // Nobody else needs to see how we internally store nodes, so
    // we keep the data class private
    private data class Node(
        var count: Int = 0,
        val children: MutableMap<Char, Node> = mutableMapOf<Char, Node>())

    // Store a pointer to the root node in the tree
    private var root: Node = Node()

    /**
     * Returns a string representation of the tree.
     */
    override fun toString(): String {
        return root.toString()
    }

    /**
     * Adds 1 to the existing count for given word, 
     * or adds given word to the WordCountTree with a count of 1 
     * if it is not already present.
     * Implementation must be recursive, not iterative.
     */
    fun incrementCount(word: String) {
        // TODO: Part A
    }

    /**
     * Returns the count of word. Returns 0 if word is not present.
     * Implementation must be recursive, not iterative.
     */
    fun getCount(word: String): Int {
        // TODO: Part A
        return 0
    }

    /**
     * Returns true if word is stored in this WordCountTree
     * with a count greater than 0, and false otherwise.
     * Implementation must be recursive, not iterative.
     */
    fun contains(word: String): Boolean {
        // TODO: Part C
        return false
    }

    /**
     * Returns a MutableMap of all words in WordCountTree that
     * start with the given prefix, mapped to their counts.
     * If prefix is not present, returns an empty MutableMap.
     */
    fun getAutocompletionMap(prefix: String): MutableMap<String, Int> {
        // TODO: Part C
        return mutableMapOf<String, Int>()
    }
}

// Reflection: TODO