import string

def removePunctuation(text):
    """
    Removes punctuation from the given text.
    
    text: a string
    returns: a copy of text without any punctuation
    """
    newText = ""
    for ch in text:
        # Use string.punctuation as the set of
        # characters to filter out
        if ch not in string.punctuation:
            newText += ch
    return newText

def normalize(text):
    """
    Normalizes the given text by making it lowercase
    and removing punctuation.
    
    text: a string
    returns: a normalized copy of text
    """
    return removePunctuation(text.lower())

def splitIntoWords(text):
    """
    Splits the given text into a list of words.

    text: a string
    returns: a list of words (each a string) in text
    """
    wordList = []

    # Go through text, keeping track of running sequences
    # of non-whitespace characters; once we find whitespace,
    # add the current sequence to the list as a word
    # and reset the sequence to empty
    prevChar = " "
    word = ""
    for ch in text:
        if ch not in string.whitespace:
            # If it's not whitespace, it's still the same word
            word += ch
        elif prevChar not in string.whitespace:
            # If it was whitespace but the previous character
            # wasn't, then we had a word and should add it
            wordList.append(word)
            word = ""
        
        # In any case, the current character will become
        # the next "previous" character
        prevChar = ch

    # If we had a word building, add that last one, too
    if word != "":
        wordList.append(word)

    return wordList

def getWordTokens(text):
    """
    Breaks the given text into words with punctuation removed.
    
    text: a string
    returns: a list of word tokens (each a lowercase string)
    """
    normalizedText = normalize(text)
    words = splitIntoWords(normalizedText)
    return words

def countWords(text):
    """
    Counts the number of words in a string.
    
    text: a string
    returns: the number of words (int)
    """
    tokens = getWordTokens(text)
    return len(tokens)