/*
    sample.js
    Jeff Ondich, 5 May 2016

    A small demo of some simple Javascript techniques.
    For CS257 Software Design, Carleton College
 */
function onLoad() {
    alert('Hi from onLoad!');
}

function onKeyPress(keyEvent) {
    // For learning about the difference between charCode and keyCode.
    //alert('charCode: ' + keyEvent.charCode + ', keyCode: ' + keyEvent.keyCode);

    // If the focus is on the text box, we don't want to change the color
    // of colorbox. If we did, we'd type "dog" and the "g" would cause the color
    // to change to green.
    var magicWordElement = document.getElementById('magicword');
    if (document.activeElement == magicWordElement) {
        return;
    }

    var colorBoxElement = document.getElementById('colorbox');

    switch (keyEvent.keyCode) {
    case 98: // b -- I haven't found a standard way to do this more readably. Let me know if you do.
        colorBoxElement.style.backgroundColor = '#2222bb';
        break;

    case 114: // r
        colorBoxElement.style.backgroundColor = '#bb2222';
        break;

    case 103: // g
        colorBoxElement.style.backgroundColor = '#22bb22';
        break;
    }
}

function onChangeMagicWordButton() {
    var colorBoxElement = document.getElementById('colorbox');
    var magicWordElement = document.getElementById('magicword');
    colorBoxElement.innerHTML = 'The magic word is "' + magicWordElement.value + '"';
}

// These two functions execute the AJAX call to get more information from
// the same server the original page came from.
function onGetDateTime() {
    var url = '/date/';
    xmlHttpRequest = new XMLHttpRequest();
    xmlHttpRequest.open('get', url);

    xmlHttpRequest.onreadystatechange = function() {
            if (xmlHttpRequest.readyState == 4 && xmlHttpRequest.status == 200) {
                dateCallback(xmlHttpRequest.responseText);
            }
        };

    xmlHttpRequest.send(null);

}

function dateCallback(responseText) {
    var dateElement = document.getElementById('servertime');
    dateElement.innerHTML = responseText;
}

