#!/usr/bin/env python3
'''
    javascript_sample.py
    Jeff Ondich, 5 May 2016

    Flask app serving up the pieces of the javascript-sample for
    CS 257, Spring 2016.
'''
import sys
import flask
import datetime

app = flask.Flask(__name__, static_folder='static', template_folder='templates')

@app.route('/')
def get_main_page():
    return flask.render_template('index.html')

@app.route('/date/')
def get_date():
    return datetime.datetime.now().strftime("%A, %d. %B %Y %I:%M:%S %p")

if __name__ == '__main__':
    if len(sys.argv) != 3:
        print('Usage: {0} host port'.format(sys.argv[0]), file=sys.stderr)
        exit()

    host = sys.argv[1]
    port = int(sys.argv[2])
    app.run(host=host, port=port, debug=True)

