import java.io.*;
import org.apache.hadoop.fs.*;
import org.apache.hadoop.io.*;
import org.apache.hadoop.mapreduce.*;
import org.apache.hadoop.mapreduce.lib.input.*;
import org.apache.hadoop.mapreduce.lib.output.*;

/**
 * MapReduce job that pipes input to output as MapReduce-created key-val pairs
 * (c) 2012 Jeannie Albrecht
 * Modified by Laura Effinger-Dean, Winter 2013. Modified again by Dave Musicant, Winter 2016.
 */
public class Trivial {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: inputDirectory outputDirectory");
            System.exit(1);
        }

        Job job = Job.getInstance();
        job.setJarByClass(Trivial.class);
        job.setMapperClass(IdentityMapper.class);
        job.setReducerClass(IdentityReducer.class);
        FileInputFormat.addInputPath(job, new Path(args[0]));
        FileOutputFormat.setOutputPath(job, new Path(args[1]));

        boolean showProgress = true;
        System.exit(job.waitForCompletion(showProgress) ? 0 : 1);
    }

    public static class IdentityMapper extends
            Mapper<LongWritable, Text, LongWritable, Text> {
        @Override
        public void map(LongWritable key, Text val, Context context)
                throws IOException, InterruptedException {

            String output = getFilename(context) + " " + val;
            context.write(key, new Text(output));
        }

        private String getFilename(Context context) {
            FileSplit fileSplit = (FileSplit)context.getInputSplit();
            String filename = fileSplit.getPath().getName();
            return filename;
        }
    }


    public static class IdentityReducer extends
            Reducer<LongWritable, Text, LongWritable, Text> {
        @Override
        public void reduce(LongWritable key, Iterable<Text> value,
                           Context context) throws IOException, InterruptedException {
            for (Text val : value) {
                context.write(key, val);
                System.out.println("key=" + key + ", val=" + val);
            }
        }
    }
}
