import java.nio.*;

/**
 * Slotted file page. This is a wrapper around a traditional Page that
 * adds the appropriate struture to it.
 *
 * @author Dave Musicant, with considerable inspiration from the UW-Madison
 * Minibase project
 */
public class SlottedPage
{
    public static class PageFullException extends RuntimeException {};
    public static class BadSlotIdException extends RuntimeException {};
    public static class BadPageIdException extends RuntimeException {};

    private static class SlotArrayOutOfBoundsException
        extends RuntimeException {};

    /**
     * Value to use for an invalid page id.
     */
    public static final int INVALID_PAGE = -1;
    public static final int SIZE_OF_INT = 4;

    private byte[] data;
    private IntBuffer intBuffer;
    private int intBufferLength;

    /**
     * Constructs a slotted page by wrapping around a page object already
     * provided.
     * @param page the page to be wrapped.
     */
    public SlottedPage(Page page)
    {
        data = page.data;
        intBuffer = (ByteBuffer.wrap(data)).asIntBuffer();
        intBufferLength = data.length / SIZE_OF_INT;
    }

    /**
     * Initializes values on the heap file page as necessary. This is
     * separated out from the constructor since it actually modifies
     * the page at hand, where as the constructor simply sets up the
     * mechanism.
     */
    public void init()
    {
    }


    /**
     * Sets the page id.
     * @param pageId the new page id.
     */
    public void setPageId(int pageId)
    {
    }

    /**
     * Gets the page id.
     * @return the page id.
     */
    public int getPageId()
    {
        return -1;
    }

    /**
     * Sets the next page id.
     * @param pageId the next page id.
     */
    public void setNextPageId(int pageId)
    {
    }

    /**
     * Gets the next page id.
     * @return the next page id.
     */
    public int getNextPageId()
    {
        return -1;
    }

    /**
     * Sets the previous page id.
     * @param pageId the previous page id.
     */
    public void setPrevPageId(int pageId)
    {
    }

    /**
     * Gets the previous page id.
     * @return the previous page id.
     */
    public int getPrevPageId()
    {
        return -1;
    }

    /**
     * Determines how much space, in bytes, is actually available on the page,
     * which depends on whether or not a new slot in the slot array is
     * needed. If a new spot in the slot array is needed, then the amount of
     * available space has to take this into consideration. In other words, the
     * space you need for the addition to the slot array shouldn't be included
     * as part of the available space, because from the user's perspective, it
     * isn't available for adding data.
     * @return the amount of available space in bytes
     */
    public int getAvailableSpace()
    {
        return -1;
    }
        

    /**
     * Dumps out to the screen the # of entries on the page, the location where
     * the free space starts, the slot array in a readable dashion, and the
     * actual contents of each record. (This method merely exists for debugging
     * and testing purposes.)
    */ 
    public void dumpPage()
    {
    }

    /**
     * Inserts a new record onto the page.
     * @param record the record to be inserted. A copy of the data is
     * placed on the page.
     * @return the RID of the new record 
     * @throws PageFullException if there is not enough room for the
     * record on the page.
    */
    public RID insertRecord(byte[] record)
    {
        return null;
    }

    /**
     * Deletes the record with the given RID from the page, compacting
     * the hole created. Compacting the hole, in turn, requires that
     * all the offsets (in the slot array) of all records after the
     * hole be adjusted by the size of the hole, because you are
     * moving these records to "fill" the hole. You should leave a
     * "hole" in the slot array for the slot which pointed to the
     * deleted record, if necessary, to make sure that the rids of the
     * remaining records do not change. The slot array should be
     * compacted only if the record corresponding to the last slot is
     * being deleted.
     * @param rid the RID to be deleted.
     * @return true if successful, false if the rid is actually not
     * found on the page.
    */
    public boolean deleteRecord(RID rid)
    {
        return false;
    }

    /**
     * Returns RID of first record on page. Remember that some slots may be
     * empty, so you should skip over these.
     * @return the RID of the first record on the page. Returns null
     * if the page is empty.
     */
    public RID firstRecord()
    {
        return null;
    }

    /**
     * Returns RID of next record on the page, where "next on the page" means
     * "next in the slot array after the rid passed in." Remember that some
     * slots may be empty, so you should skip over these.
     * @param curRid an RID
     * @return the RID immediately following curRid. Returns null if
     * curRID is the last record on the page.
     * @throws BadPageIdException if the page id within curRid is
     * invalid
     * @throws BadSlotIdException if the slot id within curRid is invalid
    */
    public RID nextRecord(RID curRid)
    {
        return null;
    }

    /**
     * Returns the record associated with an RID.
     * @param rid the rid of interest
     * @return a byte array containing a copy of the record. The array
     * has precisely the length of the record (there is no padded space).
     * @throws BadPageIdException if the page id within curRid is
     * invalid
     * @throws BadSlotIdException if the slot id within curRid is invalid
    */
    public byte[] getRecord(RID rid)
    {
        return null;
    }

    /**
     * Whether or not the page is empty.
     * @return true if the page is empty, false otherwise.
     */
    public boolean empty()
    {
        return false;
    }
}
