'''
This is the main module of the error tree. 
It holds the root node of the tree and a traversal function, getErrorMsg().

Jake Reardon
Rhys Lindmark
Matt Adams
Michael "DMizzle" Domingues
Alex "Duffle" Voorhees
Tung "Free Dominoes Delivery" Phan

Last Modified: 1/8/2012
'''

from errors import *
from BaseErrorNode import ErrorNode
import tbTools


class RootErrorNode(ErrorNode):
    '''This is the root node of the error tree.'''
    def gdn(self):
        # handled types came from docs.python.org/2/library/exceptions.html
        if self.errType == ZeroDivisionError: return ZeroDivisionErrorNode(self.errType, self.errValue, self.tb)
        elif self.errType == NameError: return NameErrorNode(self.errType, self.errValue, self.tb)
        elif self.errType == TypeError: return TypeErrorNode(self.errType, self.errValue, self.tb)
        elif self.errType == IndexError: return IndexErrorNode(self.errType, self.errValue, self.tb)
        elif self.errType == ValueError: return ValueErrorNode(self.errType, self.errValue, self.tb)
        elif self.errType == IndentationError: return SyntaxErrorNode(self.errType, self.errValue, self.tb)
        elif self.errType == KeyError: return KeyErrorNode(self.errType, self.errValue, self.tb)
        elif self.errType == UnboundLocalError: return UnboundLocalErrorNode(self.errType, self.errValue, self.tb)
        elif self.errType == KeyboardInterrupt: return KeyboardInterruptNode(self.errType, self.errValue, self.tb)
        elif self.errType == EOFError: return EOFErrorNode(self.errType, self.errValue, self.tb)
        elif self.errType == RuntimeError: return RuntimeErrorNode(self.errType, self.errValue, self.tb)
        elif self.errType == SyntaxError: return SyntaxErrorNode(self.errType, self.errValue, self.tb)
        elif self.errType == AttributeError: return AttributeErrorNode(self.errType, self.errValue, self.tb)
        else: return None

    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg(self.errType, self.errValue)


def getErrorMsg(errType, errValue, tb):
    '''
    This function returns the string value of the deepest possible node in the error tree (given the inputs). 
    This is where the tree traversal actually happens.
    '''
    deeperNode = RootErrorNode(errType, errValue, tb)
    while deeperNode != None:
        node = deeperNode
        # try to access the deeper node, if there are problems, just return
        try:
            deeperNode = node.gdn()
        except:
            break
    return str(node)
