'''
NameError and subnodes.

Rhys Lindmark

Last Modified: 1/5/2012
'''

from .. import tbTools
from ..BaseErrorNode import ErrorNode
import re


class UnboundLocalErrorNode(ErrorNode):
    def __str__(self):
        try:
            badVar = re.search(r"'\w+'",str(self.errValue)).group(0).strip("'")
        except:
            badVar = ''

        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('UnboundLocalError',"Tried to access the local variable '{}' before it was defined.".format(badVar))
