"""
Syntax Error Nodes

Michael Domingues
Tung Phan
Alex Voorhees
(small changes by Rhys and Matt)

Last Modified: 17 Feb. 2013
"""

from .. import tbTools
from ..BaseErrorNode import ErrorNode
from IndentationErrorNode import *
import sys
import parser

class SyntaxErrorNode(ErrorNode):
    def __str__(self):
        newMessage = {"'return' outside function": ["'return' statement must be written inside of a function.","The 'return' statement might not be indented to the correct level."],
                      'EOF while scanning triple-quoted string literal': ["Triple-quoted comment strings must be surrounded by matching ''' or \"\"\"."],
                      'EOL while scanning string literal': ['Strings must be surrounded by matching \' \' or " ".'],
                      'unexpected character after line continuation character': ["No characters can be written on the same line after a continuation character (\\)."],
                      "'break' outside loop":["'break' statement must be written within a loop.","The 'break' statement might not be indented to the correct level."],
                      "'continue' not properly in loop": ["'continue' statement must be written within a loop.","The 'continue' statement might not be indented to the correct level."],
                      "":['sdg']}

        if sys.isConsole:
            tbMessage = ''
        else:
            tbMessage = tbTools.get_tb_entry_str(self.errValue.filename, self.errValue.lineno, self.errValue.text.strip())
        msg = newMessage.get(self.errValue.msg, [self.errValue.msg])[0]

        if (msg != "invalid syntax" and self.errType != IndentationError):
            errMessage = tbTools.formatErrMsg('SyntaxError', msg)
            if newMessage.get(self.errValue.msg, None) and len(newMessage[self.errValue.msg])==2:
                errMessage += tbTools.formatErrMsg('Possible Indentation Issue', newMessage[self.errValue.msg][1])
            tbMessage += errMessage
        else:
            '''
            pass to pypy to handle extra syntax error message
            '''
            if self.errValue.filename == '<console>':
                code_string = self.errValue[1][3]
                syntaxChecking = parser.SyntaxChecker(None, code_string)
            else:
                syntaxChecking = parser.SyntaxChecker(self.errValue.filename)            
            if syntaxChecking:
                syntaxChecking.filename = self.errValue.filename
                if (type(syntaxChecking) == IndentationError):
                    return str(IndentationErrorNode(IndentationError, syntaxChecking, self.tb))
                elif (type(syntaxChecking) == SyntaxError):
                    return str(SyntaxErrorNode(SyntaxError, syntaxChecking, self.tb))
                else:
                    tbMessage = parser.printFormattedSyntaxMessage(syntaxChecking)
            else:
                if (self.errType == IndentationError):
                    tbMessage = str(IndentationErrorNode(IndentationError, self.errValue, self.tb))
                else:
                    errMessage = tbTools.formatErrMsg('SyntaxError', msg)
                    tbMessage += errMessage
        
        return tbMessage
        

