'''
Index Error and subnodes

Matthew Adams
Michael Domingues
Rhys Lindmark

Last Modified: 3 March 2013
'''

from .. import tbTools 
from ..BaseErrorNode import ErrorNode
import re


class IndexErrorNode(ErrorNode):
    def gdn(self):
        if str(self.errValue) == 'list assignment index out of range': return IndexErrorListAssignNode(self.errType, self.errValue, self.tb)
        elif str(self.errValue) == 'list index out of range': return IndexErrorListNode(self.errType, self.errValue, self.tb)
        elif str(self.errValue) == 'string index out of range': return IndexErrorStringNode(self.errType, self.errValue, self.tb)
        else: return None

    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('IndexError', self.errValue)
        

class IndexErrorListAssignNode(ErrorNode):
    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('IndexError', "Cannot assign value to the list, because the list index is too large.")


class IndexErrorListNode(ErrorNode):
    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('IndexError', "Cannot access value in the list, because the requested list index is too large.")
        
    def gdn(self):
        errLine = self.execStack.get_err_line()
        listAccess = re.findall(r'[a-zA-Z_]\w*\[[0-9]+\]', errLine)
        if len(listAccess) == 1:
            listAccess = listAccess[0]
            userListName = re.findall(r'([a-zA-Z_]\w*)\[', listAccess)[0]
            userListValue = self.execStack.get_value_of_variable(userListName)
            accessedIndex = int(re.findall(r'\[([0-9]+)\]', listAccess)[0])
            if len(userListValue) == accessedIndex:
                return AccessedOneGreaterThanLengthOfListNode(self.errType, self.errValue, self.tb)

class IndexErrorStringNode(ErrorNode):
    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('IndexError', "Cannot access value in the string, because the requested string index is too large.")
        
class AccessedOneGreaterThanLengthOfListNode(ErrorNode):
    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('IndexError', "Cannot access value in the list, because the requested list index is one greater than the length of the list.\n            List indicies start at 0, not 1.")
