"""
Indentation Error Nodes

Michael Domingues
Tung Phan
Alex Voorhees

Last Modified: 23 January 2013
"""

from .. import tbTools
from ..BaseErrorNode import ErrorNode
import sys

class IndentationErrorNode(ErrorNode):
    def __str__(self):
        newMessage = {'expected an indented block': 'The previous line must be followed by an indented block.',
                      'unexpected indent': 'Current line does not match indentation level of the previous line.',
                      'unindent does not match any outer indentation level': 'Current line does not match any previous indentation.'}

        # The following format needs to be used due to the strange way that Syntax-type traceback objects are built.
        # Otherwise, the file and line number information do not print at all.
        return tbTools.get_syntax_str() + tbTools.formatErrMsg('IndentationError', newMessage.get(self.errValue.msg, self.errValue.msg))
        

