"""
Attribute Error and subnodes.

Jake Reardon ft. Rhys Lindmark ft. Matty A
Small edit by Alex Voorhees
Last modified 1/7/13
"""
from .. import tbTools
from ..BaseErrorNode import ErrorNode


class AttributeErrorNode(ErrorNode):
    """
    
    """
    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('AttributeError', self.errValue)

    def gdn(self):
        if "has no attribute" in str(self.errValue):
            return ObjectHasNoAttributeNode(self.errType, self.errValue, self.tb)
        else:
            return None

class ObjectTypeErrorNode(ErrorNode):
    def __init__(self, errType, errValue, tb):
        ErrorNode.__init__(self, errType, errValue, tb)
        words = str(self.errValue).split()
        self.objectType = words[0]
        self.attributeType = words[-1]            

class ObjectHasNoAttributeNode(ObjectTypeErrorNode):
    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('AttributeError', 'Objects of type ' + self.objectType + " don't have attribute " + self.attributeType + ".")
    def gdn(self):
        #she came back for one more go, but the ole gal couldn't cut it ne more...print self.objectType
        if self.objectType == "'str'":
            return StringAttributeNode(self.errType, self.errValue, self.tb)
        if self.objectType == "'NoneType'":
            return NoneTypeAttributeNode(self.errType, self.errValue, self.tb)
        if self.objectType == "'int'":
            return IntAttributeNode(self.errType, self.errValue, self.tb)
        if self.objectType == "'float'":
            return FloatAttributeNode(self.errType, self.errValue, self.tb)
        if self.objectType == "'bool'":
            return BoolAttributeNode(self.errType, self.errValue, self.tb)
        if self.objectType == "'tuple'":
            return TupleAttributeNode(self.errType, self.errValue, self.tb)
        if self.objectType == "'list'":
            return ListAttributeNode(self.errType, self.errValue, self.tb)
        if self.objectType == "'module'":
            return ModuleAttributeNode(self.errType, self.errValue, self.tb)
        if self.objectType == "'file'":
            return FileAttributeNode(self.errType, self.errValue, self.tb)
            


class StringAttributeNode(ObjectTypeErrorNode):
    def __str__(self):
        #Remember the glory days of 'string'!!!!
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('AttributeError', "Strings cannot " + self.attributeType + ".")


class NoneTypeAttributeNode(ObjectTypeErrorNode):
    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('AttributeError', "NoneType objects cannot " + self.attributeType + ".")
        
class IntAttributeNode(ObjectTypeErrorNode):
    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('AttributeError', "Integers cannot " + self.attributeType + ".")
        
class FloatAttributeNode(ObjectTypeErrorNode):
    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('AttributeError', "Floats cannot " + self.attributeType + ".")
        
class BoolAttributeNode(ObjectTypeErrorNode):
    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('AttributeError', "Booleans cannot " + self.attributeType + ".")
        
class TupleAttributeNode(ObjectTypeErrorNode):
    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('AttributeError', "Tuples cannot " + self.attributeType + ".")

class ListAttributeNode(ObjectTypeErrorNode):
    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('AttributeError', "Lists cannot " + self.attributeType + ".")
        
class ModuleAttributeNode(ObjectTypeErrorNode):
    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('AttributeError', "Modules cannot " + self.attributeType + ".")
        
class FileAttributeNode(ObjectTypeErrorNode):
    def __str__(self):
        return tbTools.extract_tb_str(self.tb) + tbTools.formatErrMsg('AttributeError', "Files cannot " + self.attributeType + ".")


        
        
        

       