import java.net.*;
import java.util.*;
import java.io.*;

//Edited by Charles Noneman et al.

/**
 * SimpleTCPClient
 * 
 * A simple TCP client application, written in Java. Adapted from the code in
 * <em>TCP/IP Sockets in Java:  Practical Guide for
 * Programmers</em>, by
 * Kenneth L. Calvert and Michael J. Donahoo. CS 331, Winter 2008, Lab 1
 * 
 * @author Amy Csizmar Dalal
 * @version 28 December 2007
 */
public class TCPClient {
	/**
	 * The default port on which to run the server, if no other port specified.
	 */
	public static final int DEFAULT_PORT = 10001;

	/** The server-side port. This is the port to which the message will be sent. */
	private int port;

	/** The TCP socket used by the client, for sending and receiving data. */
	private Socket socket;

	/** Outgoing data is processed and sent on the socket via this stream. */
	private OutputStream out;

	/** Incoming data is processed from the socket via this stream. */
	private InputStream in;

	/** The length of the sent message, in bytes */
	private int msgLengthInBytes;

	/** The buffer in which to store the sent/received message. */
	private byte[] buffer;

	/**
	 * The default constructor for this class. Creates a TCP client object on
	 * the default port on the same machine.
	 * 
	 * @throws UnknownHostException
	 *             if we can't retrieve the IP address of the machine we're on
	 */
	public TCPClient() throws UnknownHostException {
		this(InetAddress.getLocalHost().getHostAddress(), DEFAULT_PORT);
	}

	/**
	 * Creates a TCP client object on the specified port. Also opens the input
	 * and output streams for receiving and sending messages, respectively.
	 * 
	 * @param port
	 *            The remote port to which to send the message, on the server.
	 * @param host
	 *            The hostname or IP address of the server to which to open a
	 *            connection.
	 */
	public TCPClient(String host, int port) {
		// Create the TCP connection
		this.port = port;

		try {
			// Create the socket on which to send and receive data.
			socket = new Socket(host, port);

			// Open the input and output streams for receiving/sending data.
			in = socket.getInputStream();
			out = socket.getOutputStream();
		} catch (UnknownHostException e) {
			System.err.println("Error:  unknown host " + host);
			System.exit(-1);
		} catch (IOException e) {
			System.err.println("Error:  could not create socket for host "
					+ host + " on port " + port);
			System.exit(-1);
		}
	}

	public void sendCommand(String msg) {
		sendCommand(msg.getBytes());
	}

	public void sendCommand(String msg, int numBytes) {
		try {
			out.write(msg.getBytes());
			byte[] junk = new byte[numBytes];
			int got = in.read(junk, 0, numBytes);
			if (got != numBytes) {
				System.out.println("sendCommand got: " + got);
			}
		} catch (Exception e) {
			System.out.println("WTF");
		}
	}

	public void sendCommand(byte[] buffer) {
		try {
			out.write(buffer);
			byte[] junk = new byte[2];
			int got = in.read(junk, 0, 2);
			if (got != 2) {
				System.out.println("sendCommand got: " + got);
			}
		} catch (Exception e) {
			System.out.println("WTF");
		}
	}

	// Method for clearing the inputstream
	public void clear() {
		try {
			int size = in.available();
			pause(100);
			while (in.available() != size) {
				size = in.available();
				pause(50);
			}
			in.read(new byte[in.available()]);
		} catch (Exception e) {
		}
	}

	void pause(int time) {
		try {
			Thread.sleep(time);
		} catch (Exception e) {
		}
	}

	public byte[] receive_image() {
		String output = "I";
		byte[] image = null;
		try {
			out.write(output.getBytes());
		} catch (IOException e) {
		}
		try {
			byte[] header = new byte[10];
			// This should wait until the bytes are here?
			in.read(header, 0, 10);
			if (header[0] != 35 || header[1] != 35) {
				System.err.println("WHOA!!!");
			}
			int size = in.available();
			pause(200);
			while (in.available() != size) {
				size = in.available();
				pause(50);
			}
			image = new byte[size];
			in.read(image, 0, size);
		} catch (IOException e) {
			System.err.println(e.getMessage());
		}
		return image;
	}

	/**
	 * Cleanup stuff: closes the socket and its streams before exiting.
	 */
	public void close() {
		try {
			in.close();
			out.close();
			socket.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
