import java.awt.image.*;
import java.io.*;
import java.util.*;
import java.awt.*;
import javax.swing.*;

//Contains methods for controlling robot via computer.

//Methods for controlling the robot
class RobotControl {
	TCPClient tcp;
	String sHost;
	int nPort;
	EnvironmentMapping env;
	final int IMAGE_WIDTH = 640;
	final int IMAGE_HEIGHT = 512;

	// just in case, these were the ratios with image quality "c"
	// 1622.0/((right-left)-6.144))

	// Constructor
	RobotControl(String host, int port, EnvironmentMapping env) {
		sHost = host;
		nPort = port;
		this.env = env;
		tcp = new TCPClient(host, port);
	}

	// Returns an image taken from the robot's camera
	private BufferedImage getPicture() throws NoImageException {
		tcp.sendCommand("c");
		byte[] buffer = tcp.receive_image();
		BufferedImage image = null;
		try {
			image = ImageHandler.getBufferedImage(new ByteArrayInputStream(
					buffer));
		} catch (NoImageException e) {
			tcp.clear();
			return getPicture();
		}
		return image;
	}

	// Pauses for 'time' milliseconds
	private void stop(int time) {
		try {
			Thread.sleep(time);
		} catch (Exception e) {
		}
	}

	// Pauses for 600 milliseconds
	private void stop() {
		stop(600);
	}

	// Turns on the lasers
	private void lasersOn() {
		tcp.sendCommand("l");
	}

	private double calcDistance() {
		BufferedImage r = null;
		EzImage image = null;
		try {
			r = getPicture();
			image = new EzImage(r);
		} catch (NoImageException e) {
			System.out.println("No picture");
			return -1.0;
		}
		return calcDistance(image);
	}

	// Calculates the distance in inches to the nearest wall in the direction
	// the robot is facing.
	public static double calcDistance(EzImage image) {
		int[][][] pixels = image.getPixels3D();
		int right = 0;
		int left = 0;

		// Finds the left white point
		for (int i = pixels.length - 1; i >= 0; i--) {
			for (int j = 0; j < pixels[0].length / 2; j++) {
				// if(pixels[i][j][0]+pixels[i][j][1]+pixels[i][j][2]>=600 )
				if (pixels[i][j][0] > 200
						&& (pixels[i][j][1] + pixels[i][j][2] < 100 || pixels[i][j][1]
								+ pixels[i][j][2] > 400)) {
					// System.out.println("WHITE POINT AT " + i + ", " + j);
					left = j;
					j = pixels[i].length;
					i = -1;
				}
			}
		}

		// Finds the right white point
		for (int i = pixels.length - 1; i >= 0; i--) {
			for (int j = pixels[0].length / 2; j < pixels[0].length; j++) {
				// if(pixels[i][j][0]+pixels[i][j][1]+pixels[i][j][2]>=600)
				if (pixels[i][j][0] > 200
						&& (pixels[i][j][1] + pixels[i][j][2] < 100 || pixels[i][j][1]
								+ pixels[i][j][2] > 400)) {
					// System.out.println("WHITE POINT AT " + i + ", " + j);
					right = j;
					j = pixels[i].length;
					i = -1;
				}
			}
		}

		if (right == 0 || left == 0) {
			return -1;
		}

		// Return for 'b' quality picture
		// return 811.0/((right-left)-3.072);

		// Return for 'c' quality picture
		return 1622.0 / ((right - left) - 6.144);
	}

	// Takes a picture and returns an EZImage
	public EzImage takePicture() {
		BufferedImage r = null;
		EzImage image = null;
		try {
			r = getPicture();
			image = new EzImage(r);
		} catch (NoImageException e) {
			System.out.println("No picture");
		}
		return image;
	}

	// Checks to see if the robot is within 8 inches of a wall in front of it.
	private boolean isFacingWall() {

		double distance = calcDistance();
		System.out.println(distance + " DISTANCE");
		if (distance < 8 && distance >= 0) {
			env.atWall();
			return true;
		}
		return false;
	}

	// Moves forward about 8 inches
	private void moveForward() {
		try {
			byte[] cmd = { 77, 85, 70, 50 };
			tcp.sendCommand(cmd);
		} catch (Exception e) {
		}
		System.out.println("Moving Forward");
		System.out.println("	");
		stop();
		env.movedForward();
		env.print();
	}

	// Moves a little forward ~3 or 4 inches
	private void moveALittleForward() {
		try {
			byte[] cmd = { 77, 85, 70, 35 };
			tcp.sendCommand(cmd);
		} catch (Exception e) {
		}
		System.out.println("Moving A Little Forward");
		System.out.println("	");
		stop();
	}

	// Turns Left ~90 degrees
	private void turnLeft90() {

		int type = classify();
		try {
			byte[] cmd = { 77, -99, 99, 30 };
			tcp.sendCommand(cmd);
		} catch (Exception e) {
		}
		System.out.println("Turning Left");
		System.out.println("	");
		stop();
		env.atObject(type);
		env.turnedLeft();
		env.print();
	}

	// Turns Right ~90 degrees
	private void turnRight90() {
		try {
			byte[] cmd = { 77, 99, -99, 30 };
			tcp.sendCommand(cmd);
		} catch (Exception e) {
		}
		System.out.println("Turning Right");
		System.out.println("	");
		stop();
		env.turnedRight();
		env.print();
	}

	// A turn left method for turning a very small number of degrees such that
	// our cardinal direction will remain unchanged
	private void timedTurnLeft(int milliSecs) {
		if (milliSecs > 10)
			milliSecs = 10;
		try {
			byte[] cmd = { 77, -99, 99, (byte) milliSecs };
			tcp.sendCommand(cmd);
		} catch (Exception e) {
		}
		System.out.println("Recalibrating Left");
	}

	// A turn right method for turning a very small number of degrees such that
	// our cardinal direction will remain unchanged
	private void timedTurnRight(int milliSecs) {
		if (milliSecs > 10)
			milliSecs = 10;
		try {
			byte[] cmd = { 77, 99, -99, (byte) milliSecs };
			tcp.sendCommand(cmd);
		} catch (Exception e) {
		}
		System.out.println("Recalibrating right");
	}

	// Traces the outside wall of the environment. Conceptually, like walking
	// around a maze with your right hand on a wall.
	private void traceWall() {
		while (!isFacingWall()) {
			System.out.println("NOT Facing wall");
			turnRight90();
		}
		while (isFacingWall()) {
			System.out.println("FACING WALL");
			turnLeft90();
		}

		recalibrate();
		double distance = calcDistance();
		System.out
				.println("Is this distance: " + distance + " less than 12?!?");
		if (distance < 12 && distance >= 0) {
			moveALittleForward();
			turnLeft90();
			recalibrate();
			System.out.println("Moving a little forward!!!!!!!!!!!!!!!!!!!!!");
		} else
			moveForward();
		// FIX
		while (!env.atOrigin()) {
			turnRight90();
			recalibrate();
			if (isFacingWall()) {
				turnLeft90();
				recalibrate();

				if (isFacingWall()) {
					turnLeft90();
					recalibrate();
					if (isFacingWall()) {
						turnLeft90();
						recalibrate();
					}
				}
			}
			recalibrate();
			distance = calcDistance();
			if (distance < 12 && distance >= 0) {
				moveALittleForward();
				turnLeft90();
				recalibrate();
				System.out
						.println("Moving a little forward!!!!!!!!!!!!!!!!!!!!!");
			} else
				moveForward();
		}
	}

	// this is a helper function for precalibrate that calculates the height of
	// the horizon
	private int findHorizon(int[][][] pixels, int position) {
		int height = 0;
		for (int i = pixels.length - 2; i > 10; i--) {
			if (isThisADarkClump(position, i, 90, 0, pixels)) {
				height = i;
				i = -1;
			}
		}

		return height;
	}

	private double precalibrate() {
		BufferedImage r = null;
		EzImage image = null;
		try {
			r = getPicture();
			image = new EzImage(r);
		} catch (NoImageException e) {
			System.out.println("No picture");
		}
		int[][][] pixels = image.getPixels3D();

		ArrayList<Integer> xs = new ArrayList<Integer>();
		ArrayList<Integer> ys = new ArrayList<Integer>();
		for (int i = 0; i < 10; i++) {
			int x = IMAGE_WIDTH / 2 - IMAGE_WIDTH / 10 + i * (IMAGE_WIDTH / 50);
			int y = findHorizon(pixels, x);
			pixels[y][x][0] = 255;
			pixels[y][x][1] = 0;
			pixels[y][x][2] = 0;
			// System.out.println("Got x: " + x + " y: " + y);
			if (y > 0 && y < 510) {
				xs.add(x);
				ys.add(y);
			}
		}
		image.setPixels(pixels);

		JFrame frame = new JFrame();
		JLabel label = new JLabel(new ImageIcon(r));
		frame.getContentPane().add(label);
		frame.pack();
		frame.show();

		double slope = -999.9;
		try {
			slope = Regression.getSlope(xs, ys);
			System.out.println("Got slope: " + slope);
		} catch (AmyCsizmarDalalException e) {
			pixels = null;
			return precalibrate();
		}
		return slope;
	}

	// Calls precalibrate, then turns until facing the correct direction.
	private void recalibrate() {
		double calibratevalue = precalibrate();
		while (Math.abs(calibratevalue) > 0.015) {
			System.out.println("Turning: "
					+ (int) (35 * Math.abs(calibratevalue)));
			if (calibratevalue > 0) {
				timedTurnRight((int) (35 * Math.abs(calibratevalue)));
			} else {
				timedTurnLeft((int) (35 * Math.abs(calibratevalue)));
			}
			calibratevalue = precalibrate();
		}
	}

	// Test to see if a given pixel on a map and its neighbors are within a
	// threshold color distance of a target
	private static boolean isThisALaserClump(int x, int y, int threshold,
			int[][][] pixels) {
		for (int i = x - 1; i <= x + 1; i++) {
			for (int j = y - 1; j <= y + 1; j++) {
				if (Math.abs(pixels[j][i][0] + pixels[j][i][1]
						+ pixels[j][i][2] - 750) >= threshold
						&& Math.abs(pixels[j][i][0] - 325) >= threshold)
					return false;
			}
		}
		// System.out.println("CLUMP with value: " + (pixels[y][x][0] +
		// pixels[y][x][1] + pixels[y][x][2]));
		return true;
	}

	// Test to see if a given pixel on a map and its neighbors are within a
	// threshold color distance of a target
	private static boolean isThisAClump(int x, int y, int threshold,
			int target, int[][][] pixels) {
		for (int i = x - 1; i <= x + 1; i++) {
			for (int j = y - 1; j <= y + 1; j++) {
				if (Math.abs(pixels[j][i][0] + pixels[j][i][1]
						+ pixels[j][i][2] - target) >= threshold)
					return false;
			}
		}
		// System.out.println("CLUMP with value: " + (pixels[y][x][0] +
		// pixels[y][x][1] + pixels[y][x][2]));
		return true;
	}

	// Test to see if a given pixel on a map and its neighbors are within a
	// threshold color distance of a target
	private static boolean isThisADarkClump(int x, int y, int threshold,
			int target, int[][][] pixels) {
		for (int i = x - 1; i <= x + 1; i++) {
			for (int j = y - 10; j <= y + 1; j++) {
				if (Math.abs(pixels[j][i][0] + pixels[j][i][1]
						+ pixels[j][i][2] - target) >= threshold)
					return false;
			}
		}
		// System.out.println("CLUMP with value: " + (pixels[y][x][0] +
		// pixels[y][x][1] + pixels[y][x][2]));
		return true;
	}

	// Main
	public void runAlone() {
		// BufferedImage r = null;
		// tcp.sendCommand("l");
		lasersOn();
		/*
		 * try{ r = getPicture(); } catch (NoImageException e)
		 * {System.out.println("No picture");}
		 */
		// System.out.println("Got Picture!" + r.getHeight());
		/*
		 * tcp.sendCommand("Mxxx"); tcp.sendCommand(".");
		 * System.out.println("Turned once"); tcp.sendCommand(".");
		 * tcp.sendCommand(".");
		 */
		// calcDistance();
		byte[] cmd = { 77, 120, 120, 1 };
		tcp.sendCommand(cmd);
		try {
			// Thread.sleep(3000);
		} catch (Exception e) {
		}
		traceWall();
		return;
	}

	/*
	 * unknown: -1 empty: 0 wall: 1 victim: 2 hazard: 3
	 */

	public int classify() {
		BufferedImage r = null;
		EzImage image = null;
		try {
			r = getPicture();
			image = new EzImage(r);
		} catch (NoImageException e) {
			System.out.println("No picture");
		}
		return classify(image);
	}

	private int classify(EzImage img) {
		int[][][] pixels = img.getPixels3D();
		int[] middleColor = pixels[IMAGE_HEIGHT / 2][IMAGE_WIDTH / 2];
		System.out.println("R: " + middleColor[0]);
		System.out.println("G: " + middleColor[1]);
		System.out.println("B: " + middleColor[2]);
		if (isPink(middleColor)) {
			return 2;
		} else if (isBlack(middleColor)) {
			return 1;
		} else if (isOrange(middleColor)) {
			return 3;
		}
		return -1;
	}

	private boolean isBlack(int[] color) {
		if (color[0] + color[1] + color[2] < 200) {
			return true;
		}
		return false;
	}

	private boolean isOrange(int[] color) {
		;
		if (Math.abs(color[0] - 160) < 50 && Math.abs(color[1] - 190) < 50
				&& Math.abs(color[2] - 45) < 50) {
			return true;
		}
		return false;
	}

	private boolean isPink(int[] color) {
		if (Math.abs(color[0] - 150) < 50 && Math.abs(color[1] - 150) < 50
				&& Math.abs(color[2] - 150) < 50) {
			return true;
		}
		return false;
	}
}
