import java.util.*;
import java.lang.*;
import java.io.*;

/**
 * RegressionApplet.java
 * 
 * @author Charles Stanton
 * @version April 10 1997 Totally redone by: Charles Noneman
 */

public abstract class Regression {
	/*
	 * Does the linear regression for a set of points. Returns [slope, sum of
	 * residuals]
	 */
	private static double[] makeLine(AbstractList<Integer> xs,
			AbstractList<Integer> ys) {
		// Make sure that we have at least two points
		if (xs.size() < 2 || ys.size() < 2) {
			double[] tooShortReturn = new double[3];
			tooShortReturn[0] = Double.NaN;
			tooShortReturn[1] = 0.0;
			tooShortReturn[2] = 0.0;
			return tooShortReturn;
		}
		ListIterator<Integer> itr_x = xs.listIterator();
		ListIterator<Integer> itr_y = ys.listIterator();
		double sumx = 0.0;
		double sumy = 0.0;
		double sumxx = 0.0;
		double sumyy = 0.0;
		double sumxy = 0.0;
		double n = 0.0;
		// Get the sums
		for (; itr_x.hasNext() && itr_y.hasNext();) {
			int x = itr_x.next();
			int y = itr_y.next();
			sumx += x;
			sumy += y;
			sumxx += x * x;
			sumyy += y * y;
			sumxy += x * y;
			n += 1.0;
		}

		double Sxx = sumxx - sumx * sumx / n;
		double Sxy = sumxy - sumx * sumy / n;
		double b = Sxy / Sxx;
		double a = (sumy - b * sumx) / n;

		itr_x = xs.listIterator();
		itr_y = ys.listIterator();
		double dResidualSum = 0.0;
		double dStdDevSum = 0.0;
		// Total the residuals
		for (; itr_x.hasNext() && itr_y.hasNext();) {
			int x = itr_x.next();
			int y = itr_y.next();
			dResidualSum += Math.abs(y - (a + b * x));
			dStdDevSum += Math.pow(y - (a + b * x), 2);
		}
		double[] rt = new double[3];
		rt[0] = b;
		rt[1] = dResidualSum;
		rt[2] = dStdDevSum;
		return rt;
	}

	/*
	 * Returns the slope of the flatest of two lines
	 */
	public static double getSlope(AbstractList<Integer> xs,
			AbstractList<Integer> ys) throws AmyCsizmarDalalException {
		double minResidualSum = Double.MAX_VALUE;
		double minStdev = -999.9;
		double tempStdev1 = -999.9;
		double tempStdev2 = -999.9;
		double[] minSlope = new double[2];
		minSlope[0] = Double.MAX_VALUE;
		minSlope[1] = Double.MAX_VALUE;
		ArrayList<Integer> newXs;
		ArrayList<Integer> newYs;
		Integer[] junk = new Integer[1];

		// Return if not enough data
		if (xs.size() < 3 || ys.size() < 3) {
			return 0.0;
		}

		// Try all the pairs of lines
		for (int pivot = 0; pivot < xs.size() && pivot < ys.size(); pivot++) {
			ListIterator<Integer> itr_x = xs.listIterator();
			ListIterator<Integer> itr_y = ys.listIterator();
			double residualSum = 0.0;
			double slope1 = Double.NaN;
			double slope2 = Double.NaN;
			double[] result = null;

			// The first line
			newXs = new ArrayList<Integer>();
			newYs = new ArrayList<Integer>();
			int j;
			for (j = 0; j < pivot; j++) {
				newXs.add(itr_x.next());
				newYs.add(itr_y.next());
				result = makeLine(newXs, newYs);
				slope1 = result[0];
				residualSum += result[1];
			}
			if (j > 1 && !Double.isNaN(slope1))
				tempStdev1 = Math.sqrt(result[1] / j);
			else
				tempStdev1 = 0.0;

			// The second line
			newXs = new ArrayList<Integer>();
			newYs = new ArrayList<Integer>();
			for (j = pivot; j < xs.size() && j < ys.size(); j++) {
				newXs.add(itr_x.next());
				newYs.add(itr_y.next());
				result = makeLine(newXs, newYs);
				slope2 = result[0];
				residualSum += result[1];
			}
			if (j > pivot && !Double.isNaN(slope2))
				tempStdev2 = Math.sqrt(result[1] / (j - pivot));
			else
				tempStdev2 = 0.0;

			// Store the slope if the sum of residuals is the new lowest
			if (residualSum < minResidualSum) {
				minResidualSum = residualSum;

				if (Math.abs(slope1) <= Math.abs(slope2)) {
					minSlope[0] = slope1;
					minSlope[1] = slope2;
				} else {
					minSlope[0] = slope2;
					minSlope[1] = slope1;
				}

				if (tempStdev1 > tempStdev2) {
					minStdev = tempStdev1;
				} else {
					minStdev = tempStdev2;
				}
			}
		}
		/*
		 * System.out.println("Slope 1: " + minSlope[0]);
		 * System.out.println("Slope 2: " + minSlope[1]);
		 * System.out.println("Stdev: " + minStdev);
		 */
		if (minStdev > 5) {
			throw new AmyCsizmarDalalException();
		}
		return minSlope[0];
	}
}

class AmyCsizmarDalalException extends Exception {
}
