import java.util.*;
import java.awt.Color;

//Produces a real-time map of the robot's environment

/*
 unknown:	-1
 empty: 		0
 wall:		1
 victim:		2
 hazard:		3
 */
public class EnvironmentMapping {

	int[][] map;
	int[] pos;
	int direction;
	final int INIT_SIZE = 20;
	Canvas imageMap;

	//Initializes a new canvas object called imageMap, and robots starting position at [INIT_SIZE][INIT_SIZE]
	public EnvironmentMapping() {
		map = new int[INIT_SIZE * 2][INIT_SIZE * 2];
		for (int i = 0; i < INIT_SIZE * 2; i++) {
			for (int j = 0; j < INIT_SIZE * 2; j++) {
				map[i][j] = -1;
			}
		}
		direction = 0;
		pos = new int[2];
		pos[0] = INIT_SIZE;
		pos[1] = INIT_SIZE;
		map[INIT_SIZE][INIT_SIZE] = 0;

		imageMap = new Canvas();
		imageMap.setSize(INIT_SIZE * INIT_SIZE * 2, INIT_SIZE * INIT_SIZE * 2);
	}

	//Called whenever robot has turned right, adjusts direction variable accordingly.
	void turnedRight() {
		direction = (direction + 1) % 4;
	}

	//Called whenever robot has turned left, adjusts direction variable accordingly.
	void turnedLeft() {
		direction = (direction + 3) % 4;
	}

	//Called whenever robot has moved forward, adjusts position variable.
	void movedForward() {
		switch (direction) {
		case 0:
			pos[0]++;
			break;

		case 1:
			pos[1]--;
			break;

		case 2:
			pos[0]--;
			break;

		case 3:
			pos[1]++;
			break;
		}
		map[pos[0]][pos[1]] = 0;
	}

	void atVictim() {
		atObject(2);
	}

	void atHazard() {
		atObject(3);
	}

	void atWall() {
		atObject(1);
	}

	//Used to determine when the traceWall method in RobotControl should terminate
	boolean atOrigin() {
		if (pos[0] == INIT_SIZE && pos[1] == INIT_SIZE)
			return true;
		return false;
	}

	//Determines the position of an object that the robot is facing.
	void atObject(int type) {
		System.out.println("Doing it");
		int[] objectPos = new int[2];
		objectPos[0] = pos[0];
		objectPos[1] = pos[1];
		switch (direction) {
		case 0:
			objectPos[0]++;
			break;

		case 1:
			objectPos[1]--;
			break;

		case 2:
			objectPos[0]--;
			break;

		case 3:
			objectPos[1]++;
			break;
		}
		map[objectPos[0]][objectPos[1]] = type;
	}

	//Displays color-coded imageMap
	void printGrid() {
		imageMap.setInkColor(Color.green);
		for (int i = 0; i < map.length * INIT_SIZE; i += INIT_SIZE) {

			imageMap.drawLine(i, 0, i, map.length * INIT_SIZE);
		}
		for (int i = 0; i < map[1].length * INIT_SIZE; i += INIT_SIZE) {
			imageMap.drawLine(0, i, map[1].length * INIT_SIZE, i);
		}

	}

	void print() {
		/*System.out.println("COORDINATES: " + Arrays.toString(pos));
		System.out.println("DIRECTION: " + direction);
		for (int i=0; i<INIT_SIZE*2; i++){
		    System.out.println(Arrays.toString(map[i]));
		}*/

		for (int i = 0; i < map.length; i++) {
			for (int j = 0; j < map[i].length; j++) {
				switch (map[i][j]) {
				case -1:
					imageMap.setInkColor(Color.gray);
					imageMap.fillRectangle(i * INIT_SIZE, j * INIT_SIZE,
							(i + 1) * INIT_SIZE, (j + 1) * INIT_SIZE);
					break;

				case 0:
					imageMap.setInkColor(Color.white);
					imageMap.fillRectangle(i * INIT_SIZE, j * INIT_SIZE,
							(i + 1) * INIT_SIZE, (j + 1) * INIT_SIZE);
					break;

				case 1:
					imageMap.setInkColor(Color.black);
					imageMap.fillRectangle(i * INIT_SIZE, j * INIT_SIZE,
							(i + 1) * INIT_SIZE, (j + 1) * INIT_SIZE);
					break;

				case 2:
					imageMap.setInkColor(Color.pink);
					imageMap.fillRectangle(i * INIT_SIZE, j * INIT_SIZE,
							(i + 1) * INIT_SIZE, (j + 1) * INIT_SIZE);
					break;

				case 3:
					imageMap.setInkColor(Color.orange);
					imageMap.fillRectangle(i * INIT_SIZE, j * INIT_SIZE,
							(i + 1) * INIT_SIZE, (j + 1) * INIT_SIZE);
					break;
				}
			}
		}
		printGrid();
		imageMap.setVisible(true);
	}
}
