package viewer;

import server.Client;

/**
 * Network client for the viewer.
 * 
 * @author Henry
 * 
 */
public class ViewerClient extends Client {
	Interaction interaction;

	/**
	 * we want somewhere to send the commands the server sends us
	 * 
	 * @param interaction
	 *            the interaction instance to use
	 */
	public void attachInteraction(Interaction interaction) {
		this.interaction = interaction;
	}

	/**
	 * implement the react method to simply send the cmd as received to the
	 * interaction inst
	 */
	@Override
	protected void react(String cmd) {
		interaction.serverExecute(cmd.substring(4));
	}

}
