package viewer;

import javax.media.opengl.*;

public class Lights {
	float[] light_position;

	float[] mat_shininess;

	float[] mat_specular;

	float[] mat_amb;

	float[] mat_emission;

	float[] light_diffuse;

	float[] light_ambient;

	float[] light_spec;

	// private GLViewer glViewer;

	private GL gl;

	/**
	 * Initializes light arrays and GL enviroment
	 * @param glViewer
	 * @param gl
	 */
	public Lights(GLViewer glViewer, GL gl) {
		light_position = new float[4];
		light_diffuse = new float[4];
		light_ambient = new float[4];
		mat_emission = new float[4];
		mat_shininess = new float[1];
		mat_specular = new float[4];
		light_spec = new float[4];
		// this.glViewer = glViewer;
		this.gl = gl;
	}

	/**
	 * Sets lights to inital values (hard-coded)
	 * 
	 */
	public void init() {

		moveLight(300f, -300f, 700f, 0f);
		lightDiffuse(1f, 1f, 1f, 0f);
		lightAmbient(0f, 0f, 0f, 0f);
		lightSpec(1f, 1f, 1f, 1f);
		matsSpec(1f, 1f, 1f, 1f);
		matsShine(128f);
		matsEmission(0f, 0f, 0f, 1f);
		gl.glLightfv(GL.GL_LIGHT0, GL.GL_DIFFUSE, light_diffuse, 0);
		gl.glLightfv(GL.GL_LIGHT0, GL.GL_AMBIENT, light_ambient, 0);
		gl.glLightfv(GL.GL_LIGHT0, GL.GL_POSITION, light_position, 0);
		gl.glLightfv(GL.GL_LIGHT0, GL.GL_SPECULAR, light_spec, 0);
		moveLight(-10000f, 2000f, 100f, 0f);
		lightDiffuse(.8f, .8f, .8f, 0f);
		gl.glLightfv(GL.GL_LIGHT1, GL.GL_DIFFUSE, light_diffuse, 0);
		gl.glLightfv(GL.GL_LIGHT1, GL.GL_AMBIENT, light_ambient, 0);
		gl.glLightfv(GL.GL_LIGHT1, GL.GL_POSITION, light_position, 0);
		gl.glLightfv(GL.GL_LIGHT1, GL.GL_SPECULAR, light_spec, 0);

		moveLight(8000f, 4000f, 100f, 0f);
		lightDiffuse(.8f, .8f, .8f, 0f);
		gl.glLightfv(GL.GL_LIGHT2, GL.GL_DIFFUSE, light_diffuse, 0);
		gl.glLightfv(GL.GL_LIGHT2, GL.GL_AMBIENT, light_ambient, 0);
		gl.glLightfv(GL.GL_LIGHT2, GL.GL_POSITION, light_position, 0);
		gl.glLightfv(GL.GL_LIGHT2, GL.GL_SPECULAR, light_spec, 0);

		gl.glShadeModel(GL.GL_SMOOTH);
		gl.glColorMaterial(GL.GL_FRONT, GL.GL_AMBIENT_AND_DIFFUSE);
		gl.glEnable(GL.GL_COLOR_MATERIAL);
		gl.glEnable(GL.GL_LIGHTING);
		gl.glEnable(GL.GL_LIGHT0);
		gl.glEnable(GL.GL_LIGHT1);
		gl.glEnable(GL.GL_LIGHT2);
		gl.glDepthFunc(GL.GL_LEQUAL);
		gl.glEnable(GL.GL_DEPTH_TEST);

		// gl.glMaterialfv(GL.GL_FRONT, GL.GL_EMISSION,mat_emission,0);
		// gl.glMaterialfv(GL.GL_FRONT, GL.GL_SPECULAR,mat_specular,0);
		// gl.glMaterialfv(GL.GL_FRONT, GL.GL_SHININESS,mat_shininess,0);

	}

	/**
	 * Sets light_position to specified values. Must still call glLightfv in an open GL context
	 *  with respect to light you want changed to acaully change light
	 * @param x
	 * @param y
	 * @param z
	 * @param a
	 */
	public void moveLight(float x, float y, float z, float a) {
		light_position[0] = x;
		light_position[1] = y;
		light_position[2] = z;
		light_position[3] = a;

	}
	/**
	 * Sets light_diffuse to specified values. Must still call glLightfv in an open GL context
	 *  with respect to light you want changed to acaully change light
	 * @param r
	 * @param g
	 * @param b
	 * @param a
	 */
	public void lightDiffuse(float r, float g, float b, float a) {
		light_diffuse[0] = r;
		light_diffuse[1] = g;
		light_diffuse[2] = b;
		light_diffuse[3] = a;

	}
	/**
	 * Sets light_ambient to specified values. Must still call glLightfv in an open GL context
	 *  with respect to light you want changed to acaully change light
	 * @param r
	 * @param g
	 * @param b
	 * @param a
	 */
	public void lightAmbient(float r, float g, float b, float a) {
		light_ambient[0] = r;
		light_ambient[1] = g;
		light_ambient[2] = b;
		light_ambient[3] = a;
	}
	/**
	 * Sets light_spec to specified values. Must still call glLightfv in an open GL context
	 *  with respect to light you want changed to acaully change light
	 * @param r
	 * @param g
	 * @param b
	 * @param a
	 */
	public void lightSpec(float r, float g, float b, float a) {
		light_spec[0] = r;
		light_spec[1] = g;
		light_spec[2] = b;
		light_spec[3] = a;
	}

	/**
	 * Sets mat_specular to specified values. Must still call glMaterialfv in an open GL context
	 *  to acually change material properties
	 * @param r
	 * @param g
	 * @param b
	 * @param a
	 */
	public void matsSpec(float r, float g, float b, float a) {
		mat_specular[0] = r;
		mat_specular[1] = g;
		mat_specular[2] = b;
		mat_specular[3] = a;
	}
	/**
	 * Sets mat_emission to specified values. Must still call glMaterialfv in an open GL context
	 *  to acually change material properties
	 * @param r
	 * @param g
	 * @param b
	 * @param a
	 */
	public void matsEmission(float r, float g, float b, float a) {
		mat_emission[0] = r;
		mat_emission[1] = g;
		mat_emission[2] = b;
		mat_emission[3] = a;
	}
	/**
	 * Sets mat_shininess to specified values. Must still call glMaterialfv in an open GL context
	 *  to acually change material properties
	 * @param s
	 */
	public void matsShine(float s) {
		mat_shininess[0] = s;

	}

	/**
	 * Adjusts light_diffuse array up or down by b%
	 * @param b
	 */
	public void adjustDiffuse(int b) {
		float direction;
		if (b >= 0)
			direction = 1f;
		else
			direction = -1f;

		float[] tempDiffuse = light_diffuse;
		for (int k = Math.abs(b); k > 0; k--)
			for (int i = 0; i < tempDiffuse.length; i++)
				tempDiffuse[i] = tempDiffuse[i] + direction * .01f;
		for (int i = 0; i < tempDiffuse.length; i++) {
			if (tempDiffuse[i] > 1f)
				tempDiffuse[i] = 1f;
			if (tempDiffuse[i] < 0f)
				tempDiffuse[i] = 0f;
		}

		light_diffuse = tempDiffuse;
	}


}
