package server;

/**
 * A very simple client
 * 
 * @author Henry
 * 
 */
public class Tester extends Client {

	public static void main(String[] args) throws java.io.IOException {
		// instantiate the client
		Client client = new Tester();
		// always connect to localhost and use a port that isn't used by the
		// server or viewer
		client.connect("127.0.0.1", 2005);
		// send a string command to the server to relay to all clients
		// this command tells the server to send "/quit" to all clients, which
		// will cause to viewer to quit
		client.sendString("/quit");
		// disconnect and close sockets and all that good stuff
		client.disconnect();
	}

	@Override
	/**
	 * we don't care about packets the server sends us
	 */
	protected void react(String cmd) {
		System.out.println(cmd);
	}
}
