package server;

/**
 * some basic methods that can be useful for both server and client
 * 
 * @author Henry
 * 
 */
public class Common {

	/**
	 * create a byte array containing the length of the string and the string
	 * 
	 * @param text
	 *            the string to be sent iun the packet
	 * @return the byte array to be used for the packet
	 */
	public static byte[] encodeStringPacket(String text) {
		byte[] buf = new byte[512];
		int length = text.length();
		byte[] temp = text.getBytes();
		buf = new byte[temp.length + 1];
		buf[0] = (byte) length;
		for (int i = 1; i < buf.length; i++)
			buf[i] = temp[i - 1];
		return buf;
	}

	/**
	 * extract the string from the other noise in the packet
	 * 
	 * @param buf
	 *            the byte array from the packet
	 * @return the string that was contained in the packet
	 */
	public static String decodeStringPacket(byte[] buf) {
		String cmd = new String();
		byte[] temp = new byte[512];
		int length = buf[0];
		for (int i = 1; i < buf.length; i++)
			temp[i - 1] = buf[i];
		cmd = new String(temp);
		cmd = cmd.substring(0, length);
		return cmd;
	}
}
