package server;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 * the actual class that contains the server code
 * 
 * @author Henry
 * 
 */
public class CEDSThread extends Thread {
	private DatagramSocket socket = null;

	private DatagramPacket packet;

	private String groupName;

	private InetAddress group;

	private final int CLIENT_PORT = 2006;

	private final int SERVER_PORT = 2007;

	private String cmd;

	private HashMap<InetAddress, HashMap<String, Object>> clientData;

	/**
	 * Creates a new thread to run the server on with the default name
	 * 
	 * @throws IOException
	 */
	public CEDSThread() throws IOException {
		this("CarlEngine Dedicated Server");
	}

	/**
	 * Creates a new thread to run the server on
	 * 
	 * @param name
	 *            the name of the thread
	 * @throws IOException
	 */
	public CEDSThread(String name) throws IOException {
		super(name);
		clientData = new HashMap<InetAddress, HashMap<String, Object>>();
		socket = new DatagramSocket(SERVER_PORT);
		// I don't feel like we need it random
		// and I don't feel like figuring out all of the reserved address
		/*
		 * Random generator = new Random(); groupName =
		 * Integer.toString(generator.nextInt(256)) + "." +
		 * Integer.toString(generator.nextInt(256)) + "." +
		 * Integer.toString(generator.nextInt(256)) + "." +
		 * Integer.toString(generator.nextInt(256));
		 */
		groupName = "230.0.0.1";
		group = InetAddress.getByName(groupName);
	}

	/**
	 * very basic rely of packets from one source to all sources with a special
	 * case for connecting clients in order to send the group they should join
	 */
	@Override
	public void run() {
		while (true)
			try {
				byte[] buf = new byte[512];
				packet = new DatagramPacket(buf, buf.length);
				socket.receive(packet);

				cmd = Common.decodeStringPacket(packet.getData());
				if (cmd.equals("/connect")) {
					InetAddress addr = packet.getAddress();
					int port = packet.getPort();

					buf = new byte[512];
					buf = Common.encodeStringPacket(groupName);
					packet = new DatagramPacket(buf, buf.length, addr, port);
					socket.send(packet);
					clientData.put(addr, new HashMap<String, Object>());
				} else {
					buf = new byte[512];
					buf = Common.encodeStringPacket(cmd);
				}
				packet = new DatagramPacket(buf, buf.length, group, CLIENT_PORT);
				socket.send(packet);
			} catch (IOException e) {
				e.printStackTrace();
			}
	}
}
