package preditor;

import java.util.*;

/**
 * A simple stack. Holds generic objects.
 * Specifically intended for the Preditor package within the Campus Model
 * project.
 * @author chasmand
 */

public class CMStack<E> {
	Object E;
	public LinkedList<E> stack;
	
	/**
	 * Constructs a new stack of type E.
	 */
	public CMStack() {
		stack = new LinkedList<E>();
	}
	
	/**
	 * Adds a new model to the top of the stack.
	 * @param e item to be added
	 * @return the recently added model
	 */
	public E push(E e) {
		stack.add(0, e);		
		return e;
	}
	
	/**
	 * Pops the model off the top of the stack.
	 * @return top entry or null if empty stack
	 */
	public E pop() {
		E e = null;
		if (!this.isEmpty()) 
			e = stack.remove(0);
		return e;
	}
	
	/**
	 * Peeks at top model in stack, without removing it.
	 * @return top of stack
	 */
	public E peek() {
		E e = null;
		if (!this.isEmpty()) 
			e = stack.get(0);
		return e;
	}	
	
	/**
	 * Tests for emptiness of modelStack.
	 * @return true if empty; false otherwise
	 */
	public boolean isEmpty() {
		if (stack.size() == 0) 
			return true;
		return false;
	}

  /**
   * Return the size of the stack.
   * Added by Henry Gross.
   * @return the size of the internal stack
   */
  public int size() {
    return stack.size();
  }
  
	/**
	 * Prints the current stack. (Mostly for testing purposes.)
	 */
	public void print() {
		while (!this.isEmpty()) {
			System.out.println(this.pop());
		}
	}
}
