package model;

/**
 * A 3d vector used to calculate cross-products for normal vectors.
 */
public class Vector3d {
    public static final int SIZE = 3;
    
    private double[] vector;
    private double[] normalized;
    
    public Vector3d(){
        init();
    }
    public Vector3d(double[] v){
        setVector(v);
    }
    public Vector3d(Vector3d v){
        setVector(v);
    }
    
    private void init(){
        vector = new double[SIZE];
        normalized = null;
    }
    public void setVector(double[] v){
        init();
        if(v.length == SIZE)
            System.arraycopy(v, 0, vector, 0, SIZE);
    }
    public void setVector(Vector3d v){
        setVector(v.getVector());
    }
    
    public double[] getVector(){
        return vector;
    }
    public double[] getNormalized(){
        return normalize();
    }
    
    /**
     * Returns the cross product of the specified vectors.
     * @param v1 first vector
     * @param v2 second vector
     * @return cross product
     */
    public static Vector3d crossProduct(double[] v1, double[] v2){
        double[] v = new double[SIZE];
        
        if(SIZE==3){    // this could probably be cleaner...
            v[0] = v1[1]*v2[2] - v1[2]*v2[1];
            v[1] = v1[2]*v2[0] - v1[0]*v2[2];
            v[2] = v1[0]*v2[1] - v1[1]*v2[0];
        }
        
        return new Vector3d(v);
    }
    
    /**
     * Returns the normalization of this vector.
     * @return this vector, normalized
     */
    public double[] normalize(){
        if(normalized != null)
            return normalized;
        
        normalized = new double[SIZE];
        double norm = 0;
        for(int i=0; i<SIZE; i++)
            norm += vector[i]*vector[i];
        norm = Math.sqrt(norm);
        
        for(int i=0; i<SIZE; i++)
            normalized[i] = vector[i]/norm;
        
        return normalized;
    }
}
