package model;

import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import com.sun.opengl.util.GLUT;

/**
 * Draws a HalfCylinderWall extended in the z direction to form a prism.
 * The basic code was copied from PrimitiveHalfCylinderWall and modified.
 */
public class PrimitiveThickHalfCylinderWall extends PrimitiveObject {
    private static int numSegments = 10;
    private static double insideRatio = 0.8;
    
    public PrimitiveThickHalfCylinderWall(Model model) {
        super(model);
        vertices = new float[(numSegments+1)*2][4];
        for(int i=0; i<numSegments+1; i++){
            vertices[i][0] = -(float)Math.cos((Math.PI*i)/numSegments);
            vertices[i][1] = (float)Math.sin((Math.PI*i)/numSegments);
            vertices[i][2] = 0f;
            vertices[i][3] = 1f;
            
            vertices[i+numSegments+1][0] =
                    -(float)(Math.cos((Math.PI*(numSegments-i))/numSegments)*insideRatio);
            vertices[i+numSegments+1][1] =
                    (float)(Math.sin((Math.PI*i)/numSegments)*insideRatio);
            vertices[i+numSegments+1][2] = 0f;
            vertices[i+numSegments+1][3] = 1f;
        }
        
        computedVertices = new float[0][0];
        objectType.setObjType("PrimitiveThickHalfCylinderWall");
        while(texturePath.size() < 1)
            texturePath.add("none");
    }
    
    /**
     * Draws the thick half-cylinder-wall to the current gl list.
     */
    protected void drawToList(GL gl, GLU glu, GLUT glut){
        glCalculated = true;
        
        // draw the outside half cylinder wall
        for(int i=0; i<numSegments; i++){
            gl.glBegin(GL.GL_POLYGON);
                gl.glNormal3d(vertices[i][0], vertices[i][1], 0);
                gl.glVertex3d(vertices[i][0], vertices[i][1], vertices[i][2]);
                gl.glNormal3d(vertices[i+1][0], vertices[i+1][1], 0);
                gl.glVertex3d(vertices[i+1][0], vertices[i+1][1], vertices[i+1][2]);
                gl.glNormal3d(vertices[i+1][0], vertices[i+1][1], 0);
                gl.glVertex3d(vertices[i+1][0], vertices[i+1][1], vertices[i+1][2]+1);
                gl.glNormal3d(vertices[i][0], vertices[i][1], 0);
                gl.glVertex3d(vertices[i][0], vertices[i][1], vertices[i][2]+1);
                
            gl.glEnd();
            gl.glEnable(GL.GL_NORMALIZE); 
        }
        
        // draw the inside half cylinder wall
        for(int i=0; i<numSegments; i++){
            gl.glBegin(GL.GL_POLYGON);
                
                gl.glNormal3d(-vertices[i+numSegments+1][0],
                              -vertices[i+numSegments+1][1], 0);
                gl.glVertex3d(vertices[i+numSegments+1][0],
                              vertices[i+numSegments+1][1],
                              vertices[i+numSegments+1][2]);
                gl.glNormal3d(-vertices[i+numSegments+2][0],
                              -vertices[i+numSegments+2][1], 0);
                gl.glVertex3d(vertices[i+numSegments+2][0],
                              vertices[i+numSegments+2][1],
                              vertices[i+numSegments+2][2]);
                gl.glNormal3d(-vertices[i+numSegments+2][0],
                              -vertices[i+numSegments+2][1], 0);
                gl.glVertex3d(vertices[i+numSegments+2][0],
                              vertices[i+numSegments+2][1],
                              vertices[i+numSegments+2][2]+1);
                gl.glNormal3d(-vertices[i+numSegments+1][0],
                              -vertices[i+numSegments+1][1], 0);
                gl.glVertex3d(vertices[i+numSegments+1][0],
                              vertices[i+numSegments+1][1],
                              vertices[i+numSegments+1][2]+1);
                
            gl.glEnd();
            gl.glEnable(GL.GL_NORMALIZE); 
        }
        
        // draw the bottom surface connection the two half cylinder walls
        gl.glBegin(GL.GL_QUAD_STRIP);
            gl.glNormal3d(0, 0, -1);
            for(int i=0; i<numSegments+1; i++){
                gl.glVertex3d(vertices[i][0],
                              vertices[i][1],
                              vertices[i][2]);
                gl.glVertex3d(vertices[numSegments*2+1-i][0],
                              vertices[numSegments*2+1-i][1],
                              vertices[numSegments*2+1-i][2]);
            }
        gl.glEnd();
        gl.glEnable(GL.GL_NORMALIZE);
        
        // draw the top surface connection the two half cylinder walls
        gl.glBegin(GL.GL_QUAD_STRIP);
            gl.glNormal3d(0, 0, 1);
            for(int i=0; i<numSegments+1; i++){
                gl.glVertex3d(vertices[i][0],
                              vertices[i][1],
                              vertices[i][2]+1);
                gl.glVertex3d(vertices[numSegments*2+1-i][0],
                              vertices[numSegments*2+1-i][1],
                              vertices[numSegments*2+1-i][2]+1);
            }
        gl.glEnd();
        gl.glEnable(GL.GL_NORMALIZE);
        
        // draw the small left base rectangle
        gl.glBegin(GL.GL_POLYGON);
            gl.glNormal3d(0, -1, 0);
            gl.glVertex3d(vertices[0][0], vertices[0][1], vertices[0][2]);
            gl.glVertex3d(vertices[0][0], vertices[0][1], vertices[0][2]+1);
            gl.glVertex3d(vertices[numSegments*2+1][0],
                          vertices[numSegments*2+1][1],
                          vertices[numSegments*2+1][2]+1);
            gl.glVertex3d(vertices[numSegments*2+1][0],
                          vertices[numSegments*2+1][1],
                          vertices[numSegments*2+1][2]);
        gl.glEnd();
        gl.glEnable(GL.GL_NORMALIZE);
        
        // draw the small right base rectangle
        gl.glBegin(GL.GL_POLYGON);
            gl.glNormal3d(0, -1, 0);
            gl.glVertex3d(vertices[numSegments][0],
                    vertices[numSegments][1],
                    vertices[numSegments][2]);
            gl.glVertex3d(vertices[numSegments][0],
                    vertices[numSegments][1],
                    vertices[numSegments][2]+1);
            gl.glVertex3d(vertices[numSegments+1][0],
                          vertices[numSegments+1][1],
                          vertices[numSegments+1][2]+1);
            gl.glVertex3d(vertices[numSegments+1][0],
                          vertices[numSegments+1][1],
                          vertices[numSegments+1][2]);
        gl.glEnd();
        gl.glEnable(GL.GL_NORMALIZE);
    }
}
