package model;

import java.io.PrintWriter;
import java.util.*;
import javax.media.opengl.*;
import javax.media.opengl.glu.*;
import com.sun.opengl.util.*;

/**
 * A simple sphere class, using gluQuadric. With transformations, can be used
 * to draw any ellipsoid.
 */
public class PrimitiveSphere extends PrimitiveObject {
    
    public PrimitiveSphere(Model model) {
        super(model);
        vertices = new float[0][0];
        computedVertices = new float[0][0];
        objectType.setObjType("PrimitiveSphere");
        while(texturePath.size() < 1)
        	texturePath.add("none");
    }
    
    protected void readInPrimitive(Scanner scanner){
        
    }
    
    protected void writeOutPrimitive(PrintWriter writer){
        
    }
    
    /**
     * Draws the sphere to the current gl list.
     */
    protected void drawToList(GL gl, GLU glu, GLUT glut){
        glCalculated = true;
        
        
        if(textureOn && !texturePath.get(0).equals("none")){
            
    		gl.glTexEnvf(GL.GL_TEXTURE_ENV,GL.GL_TEXTURE_ENV_MODE,GL.GL_MODULATE);
      
            	t[0].enable();
            	t[0].bind();   	
         
    	}
        
        GLUquadric quadric = glu.gluNewQuadric();
        glu.gluQuadricDrawStyle(quadric, GLU.GLU_FILL);
        glu.gluQuadricNormals(quadric, GLU.GLU_SMOOTH);
        glu.gluQuadricTexture(quadric, textureOn);
        glu.gluSphere(quadric, 0.5, 20, 20);
        
        if(textureOn && !texturePath.get(0).equals("none")){
  	       t[0].disable();
          	t[0].dispose();
          }
    }
}
