package model;

/**
 * Extending PrimitiveHalfCube, PrimitiveRoof just initializes the class
 * with different values for the vertices, faces, and normal vectors.
 */
public class PrimitiveRoof extends PrimitiveHalfCube {
    public PrimitiveRoof(Model model) {
        super(model);
        
        vertices = new float[][]
            {{0f, 0f, 0f, 1f},  // (0,0,0) 0
             {0f, 1f, 1f, 1f},  // (0,1,1) 1
             {0f, 2f, 0f, 1f},  // (0,2,0) 2
             {1f, 0f, 0f, 1f},  // (1,0,0) 3
             {1f, 1f, 1f, 1f},  // (1,1,1) 4
             {1f, 2f, 0f, 1f}}; // (1,2,0) 5
        
        faces = new int[][]
            {{ 0, 1, 2, -1 },   // negative x   (triangle)
             { 0, 1, 4, 3 },    // negative y   (rectangle)
             { 0, 2, 5, 3 },    // negative z   (rectangle)
             { 1, 2, 5, 4 },    // positive y   (rectangle)
             { 3, 4, 5, -1 }};  // positive x   (triangle)
        normals = new int[][]
            {{ -1, 0, 0 },      // negative x   (triangle)
             { 0, -1, 1 },      // negative y   (rectangle)
             { 0, 0, -1 },      // negative z   (rectangle)
             { 0, 1, 1 },       // positive y   (rectangle)
             { 1, 0, 0 }};      // positive x   (triangle)
        
        objectType.setObjType("PrimitiveRoof");
    }
}
