package model;

import java.io.PrintWriter;
import java.util.*;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import com.sun.opengl.util.GLUT;

/**
 * A simple pyramid with a rectangular base. Supports textures.
 */
public class PrimitivePyramid extends PrimitiveObject {
    
    public int numSides;
    private double[][] normals;
    
    public PrimitivePyramid(Model model) {
        super(model);
        numSides = 4;
        initVertices();
        normals = new double[numSides][3];
        objectType.setObjType("PrimitivePyramid");
        while(texturePath.size() < numSides + 2)
        	texturePath.add("none");
    }
    
    public int getNumSides() {
        return numSides;
    }
    public void setNumSides(int numSides) {
        this.numSides = numSides;
        while(texturePath.size() < numSides + 2)
        	texturePath.add("none");
    }
    
    /**
     * Initializes the default values for the vertices of the pyramid.
     */
    protected void initVertices(){
        vertices = new float[numSides+1][4];
        computedVertices = new float[numSides+1][4];
        
        vertices[0][0] = 0.5f;
        vertices[0][1] = 0.5f;
        vertices[0][2] = 1;
        
        vertices[1][0] = 0;
        vertices[1][1] = 0;
        vertices[1][2] = 0;
        vertices[2][0] = 1;
        vertices[2][1] = 0;
        vertices[2][2] = 0;
        vertices[3][0] = 1;
        vertices[3][1] = 1;
        vertices[3][2] = 0;
        vertices[4][0] = 0;
        vertices[4][1] = 1;
        vertices[4][2] = 0;
    }
    
    /**
     * Reads in special information about a pyramid (i.e., number of base sides).
     * CURRENTLY NOT CALLED
     */
    protected void readInPrimitive(Scanner scanner){
        if(scanner.hasNextInt())
            numSides = scanner.nextInt();
        
        vertices = new float[numSides+1][4];
        computedVertices = new float[numSides+1][4];
    }
    
    /**
     * Writes out special information about a pyramid (i.e., number of base sides).
     * CURRENTLY NOT CALLED
     */
    protected void writeOutPrimitive(PrintWriter writer){
        writer.println(numSides);
    }
    
    /**
     * Draws the pyramid to the current gl list.
     */
    protected void drawToList(GL gl, GLU glu, GLUT glut){
        glCalculated = true;
        
        // first vertex is the top point
        // all other vertices are the base points

        // build the base first
        gl.glBegin(GL.GL_POLYGON);
        gl.glNormal3d(0, 0, -1);
        for(int i=1; i<vertices.length; i++){
            gl.glVertex3d(vertices[i][0], vertices[i][1], vertices[i][2]);
        }
        gl.glEnd();
        
        
        // then build the sides
        
        // compute normals first
        double[] v1 = new double[3], v2 = new double[3], normal;
        for(int i=1; i<vertices.length-1; i++){
            v1[0] = vertices[i+1][0] - vertices[i][0];
            v1[1] = vertices[i+1][1] - vertices[i][1];
            v1[2] = vertices[i+1][2] - vertices[i][2];
            
            v2[0] = vertices[0][0] - vertices[i][0];
            v2[1] = vertices[0][1] - vertices[i][1];
            v2[2] = vertices[0][2] - vertices[i][2];
            
            normal = Vector3d.crossProduct(v1, v2).getNormalized();
            normals[i-1][0] = normal[0];
            normals[i-1][1] = normal[1];
            normals[i-1][2] = normal[2];
        }
        v1[0] = vertices[1][0] - vertices[vertices.length-1][0];
        v1[1] = vertices[1][1] - vertices[vertices.length-1][1];
        v1[2] = vertices[1][2] - vertices[vertices.length-1][2];
        
        v2[0] = vertices[0][0] - vertices[vertices.length-1][0];
        v2[1] = vertices[0][1] - vertices[vertices.length-1][1];
        v2[2] = vertices[0][2] - vertices[vertices.length-1][2];
        
        normal = Vector3d.crossProduct(v1, v2).getNormalized();
        normals[vertices.length-2][0] = normal[0];
        normals[vertices.length-2][1] = normal[1];
        normals[vertices.length-2][2] = normal[2];
        
        // now draw vertices/normals
        for(int i=1; i<vertices.length-1; i++){
            gl.glBegin(GL.GL_POLYGON);
                gl.glNormal3d(normals[i-1][0], normals[i-1][1], normals[i-1][2]);
                if(textureOn && !texturePath.get(i).equals("none")){
                	t[i].enable();
                	t[i].bind();  
                }
            //    if(textureOn && !texturePath.get(vertices.length-1).equals("none"))
                gl.glTexCoord2f(0f,0f);
                gl.glVertex3d(vertices[0][0], vertices[0][1], vertices[0][2]);
                
                gl.glTexCoord2f(1f,0f);
                gl.glVertex3d(vertices[i][0], vertices[i][1], vertices[i][2]);
                
                gl.glTexCoord2f(1f,1f);
                gl.glVertex3d(vertices[i+1][0], vertices[i+1][1], vertices[i+1][2]);

            gl.glEnd();
            if(textureOn && !texturePath.get(i).equals("none")){
            	t[i].disable();
            	t[i].dispose();  
            }
        }
        gl.glBegin(GL.GL_POLYGON);
            gl.glNormal3d(normals[vertices.length-2][0],
                          normals[vertices.length-2][1],
                          normals[vertices.length-2][2]);
            
            if(textureOn && !texturePath.get(vertices.length-1).equals("none")){
            	t[vertices.length-1].enable();
            	t[vertices.length-1].bind();  
            }
        //    if(textureOn && !texturePath.get(vertices.length-1).equals("none"))
            //	gl.glTexCoord2f(texPoints[vertices.length-1][0],texPoints[vertices.length-1][1]);
            gl.glVertex3d(vertices[0][0], vertices[0][1], vertices[0][2]);
            gl.glVertex3d(vertices[vertices.length-1][0],
                          vertices[vertices.length-1][1],
                          vertices[vertices.length-1][2]);
            gl.glVertex3d(vertices[1][0], vertices[1][1], vertices[1][2]);
        gl.glEnd();
        if(textureOn && !texturePath.get(vertices.length-1).equals("none")){
        	t[vertices.length-1].disable();
        	t[vertices.length-1].dispose();  
        }
    }
}
