package model;

import java.io.PrintWriter;
import java.util.*;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import com.sun.opengl.util.GLUT;
import com.sun.opengl.util.texture.TextureIO;

/**
 * The base class all PrimitiveObjects extend.
 */
public class PrimitiveObject extends ComplexObject {
    protected float[][] vertices;
    protected float[][] computedVertices;
    protected int polyMode;
    protected int fillMethod;   // not used currently, but will be for color vs texture
    
    public PrimitiveObject(Model model){
        super(model);
        setPolyMode(GL.GL_FILL);
        //setFillMethod(fillMethod);
        fillColor = new float[4];
        setFillColor(1, 1, 1, 1);
        setPriority(1);
        texturePath = new ArrayList<String>();
        
    //    texturePath = new StringBuffer l{"none","none","none","none","none","none"};
    }
    
    public int getPolyMode() {
        return polyMode;
    }
    public void setPolyMode(int polyMode) {
        switch(polyMode){
            case GL.GL_LINE:
                this.polyMode = GL.GL_LINE;
                break;
            case GL.GL_FILL:
            default:
                this.polyMode = GL.GL_FILL;
                break;
        }
    }
    
    public void setTexturesOn(boolean b){
        if(b != textureOn)
            glCalculated = false;
        textureOn = b;
    }
    
    public int getFillMethod() {
        return fillMethod;
    }
    public void setFillMethod(int fillMethod) {
        this.fillMethod = fillMethod;
    }
    
    // this method should be over-ridden in any child classes
    protected void drawToList(GL gl, GLU glu, GLUT glut){}
    
    // this method should be over-ridden in any child classes
    protected void readInPrimitive(Scanner scanner){}
    
    // this method should be over-ridden in any child classes
    protected void writeOutPrimitive(PrintWriter writer){}
    

    
    public void load(ModelFile mf){
        glCalculated = false;
        
        setPolyMode(GL.GL_FILL);    //LINE);
        
        mf.startNewObject();
        setTexture(mf.readString());
        setAlias(mf.readString());
        setPriority(mf.readInt());
        setFillColor(mf.readNFloats(4));
        transformation.transformTo(mf.readNFloats(3),
                mf.readNFloats(3), mf.readNFloats(3));
    }
    
    public void write(PrintWriter writer, ModelFile mf){	
        if (texturePath != null) {
            for (int i = 0; i < texturePath.size(); i++) {
                writer.print(texturePath.get(i) + " ");     //Writes out texture path
            }
        }
        
        writer.println();
        
        mf.writeString(writer, alias);
        mf.writeString(writer, ""+priority);
        mf.writeFloatArray(writer, fillColor);
        
        mf.writeFloatArray(writer, transformation.getTranslation());
        mf.writeFloatArray(writer, transformation.getRotation());
        mf.writeFloatArray(writer, transformation.getScale());
    }
    
    public void draw(boolean forceRender){
        
        if(forceRender || !glCalculated){
            //System.err.println("Force draw: "+getAlias());
            GL gl = model.getGL();
            GLU glu = model.getGLU();
            GLUT glut = model.getGLUT();
            //System.err.println("***");
            
			for(int i = 0;i<texturePath.size();i++){
				if(textureOn && !texturePath.get(i).equals("none")){
					//t[i] = TextureIO.newTextureData(new File(viewer.Viewer.getDataPath() + texturePath[i]),false, texturePath[i].substring(texturePath[i].length() - 3) );
					t[i] = TextureIO.newTexture(td[i]);
					t[i].setTexParameteri(GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT);
					t[i].setTexParameteri(GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT);
			//		t[i].setTexParameteri(GL.GL_TEXTURE_MAG_FILTER, GL.GL_NICEST);
					
					//System.err.println(t[i].getEstimatedMemorySize());
					
				}
			}
            
            //  Just re-calculate the vertices instead of messing with the matrix.
            gl.glPushMatrix();
            
            // what the heck is the second parameter?
            gl.glMultMatrixf(transformation.getTransMatrix().getMatrix(), 0); 
            
            
            //calculateVertices();
            
            gl.glPolygonMode(GL.GL_FRONT_AND_BACK, polyMode);
            
            gl.glColor4f(fillColor[0],
                         fillColor[1],
                         fillColor[2],
                         fillColor[3]);
       //     if(alias.equals("Sky"))
     //       	gl.glMaterialfv( gl.GL_FRONT_AND_BACK, gl.GL_AMBIENT, new float[] {1f,1f,1f,1},0 ) ;
            
            drawToList(gl, glu, glut);
            
            //  Don't need to reset matrix if we're just re-calculating vertices.
            // now that we're out of the scope of these transformations,
            // let's set the transformation matrix back to what it was
     //       if(alias.equals("Sky"))
       //     	gl.glMaterialfv( gl.GL_FRONT, gl.GL_EMISSION, new float[] {0,0,0,1},0 ) ;
            
            gl.glPopMatrix();
            
        }
    }
    
    protected void calculateVertices(){
        transformation.getTransMatrix().multVertices(vertices, computedVertices);
    }
    public int getverticesLength(){
    	return vertices.length;
    }
}
