package model;

import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

import com.sun.opengl.util.GLUT;

public class PrimitiveHalfCylinderWall extends PrimitiveObject {
    private static int numSegments = 10;
    
    public PrimitiveHalfCylinderWall(Model model) {
        super(model);
        vertices = new float[numSegments+1][4];
        for(int i=0; i<numSegments+1; i++){
            vertices[i][0] = -(float)Math.cos((Math.PI*i)/numSegments);
            vertices[i][1] = (float)Math.sin((Math.PI*i)/numSegments);
            vertices[i][2] = 0f;
            vertices[i][3] = 1f;
        }
        
        computedVertices = new float[0][0];
        objectType.setObjType("PrimitiveHalfCylinderWall");
        while(texturePath.size() < 1)
            texturePath.add("none");
    }
    
    /**
     * Draws the half-cylinder-wall to the current gl list.
     */
    protected void drawToList(GL gl, GLU glu, GLUT glut){
        glCalculated = true;
        
        for(int i=0; i<numSegments; i++){
            gl.glBegin(GL.GL_POLYGON);
                gl.glNormal3d(vertices[i][0], vertices[i][1], 0);
                gl.glVertex3d(vertices[i][0], vertices[i][1], vertices[i][2]);
                gl.glNormal3d(vertices[i+1][0], vertices[i+1][1], 0);
                gl.glVertex3d(vertices[i+1][0], vertices[i+1][1], vertices[i+1][2]);
                gl.glNormal3d(vertices[i+1][0], vertices[i+1][1], 0);
                gl.glVertex3d(vertices[i+1][0], vertices[i+1][1], vertices[i+1][2]+1);
                gl.glNormal3d(vertices[i][0], vertices[i][1], 0);
                gl.glVertex3d(vertices[i][0], vertices[i][1], vertices[i][2]+1);
                
            gl.glEnd();
            gl.glEnable(GL.GL_NORMALIZE); 
        }
    }
}
