package model;

import java.io.PrintWriter;
import java.util.*;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import com.sun.opengl.util.GLUT;

/**
 * This is essentially a cube cut diagonally across two axes, forming a "roof" object
 */

public class PrimitiveHalfCube extends PrimitiveObject {
    protected int[][] faces = 
            {{ 0, 1, 2, -1 },   // negative z   (triangle)
             { 0, 1, 4, 3 },    // negative y   (rectangle)
             { 0, 2, 5, 3 },    // negative x   (rectangle)
             { 1, 2, 5, 4 },    // positive x,y (rectangle)
             { 3, 4, 5, -1 }};  // positive z   (triangle)
    protected int[][] normals =
            {{ 0, 0, -1 },      // negative z
             { 0, -1, 0 },      // negative y
             { -1, 0, 0 },      // negative x
             { 1, 1, 0 },       // positive x,y
             { 0, 0, 1 }};      // positive z
    
    public PrimitiveHalfCube(Model model) {
        super(model);
        //originalVertices = new float[6][4];
        vertices = new float[][]
            {{0f, 0f, 0f, 1f},
             {1f, 0f, 0f, 1f},
             {0f, 1f, 0f, 1f},
             {0f, 0f, 1f, 1f},
             {1f, 0f, 1f, 1f},
             {0f, 1f, 1f, 1f}};
        computedVertices = new float[6][4];
        objectType.setObjType("PrimitiveHalfCube");
        while(texturePath.size() < 5)
            texturePath.add("none");
        
    }
    
    protected void readInPrimitive(Scanner scanner){
        // nothing special for a HalfCube, just the normal PrimitiveObject data members
    }
    
    protected void writeOutPrimitive(PrintWriter writer){
        // nothing special for a HalfCube, just the normal PrimitiveObject data members
    }
    
    /**
     * Draws the half-cube to the current gl list.
     */
    protected void drawToList(GL gl, GLU glu, GLUT glut){
        glCalculated = true;
        
        for(int i=0; i<faces.length; i++){
        
            if(textureOn && !texturePath.get(i).equals("none")){
                t[i].enable();
                t[i].bind();  
            }
            
            gl.glBegin(GL.GL_POLYGON);
            gl.glNormal3d(normals[i][0], normals[i][1], normals[i][2]);
                for(int j=0; j<faces[i].length; j++){
                    if(faces[i][j] >= 0){
                        if(textureOn && !texturePath.get(i).equals("none"))
                            gl.glTexCoord2f(texPoints[j][0],texPoints[j][1]);
                        
                        gl.glVertex3d(vertices[faces[i][j]][0],
                                      vertices[faces[i][j]][1],
                                      vertices[faces[i][j]][2]);
                    }
                }
            gl.glEnd();
            
            gl.glEnable(GL.GL_NORMALIZE); 
            if(textureOn && !texturePath.get(i).equals("none")){
                t[i].disable();
                t[i].dispose();
            }
        }
    }
}
