package model;

import java.io.PrintWriter;
import java.util.*;
import javax.media.opengl.*;
import javax.media.opengl.glu.*;
import com.sun.opengl.util.*;

public class PrimitiveCylinder extends PrimitiveObject {
    
    //private double baseCenterX, baseCenterY, radius, height;
    
    public PrimitiveCylinder(Model model) {
        super(model);
        vertices = new float[0][0];
        computedVertices = new float[0][0];
        objectType.setObjType("PrimitiveCylinder");
        while(texturePath.size() < 3)
        	texturePath.add("none");
    }
    
    protected void readInPrimitive(Scanner scanner){
        
    }
    
    protected void writeOutPrimitive(PrintWriter writer){
        
    }
    
    /**
     * Draws the cylinder to the current gl list.
     */
    protected void drawToList(GL gl, GLU glu, GLUT glut){
        glCalculated = true;
        
        GLUquadric quadric = glu.gluNewQuadric();
        glu.gluQuadricDrawStyle(quadric, GLU.GLU_FILL);
        glu.gluQuadricNormals(quadric, GLU.GLU_SMOOTH);
        glu.gluQuadricTexture(quadric, textureOn);
        Matrix4x4f tempMatrix = new Matrix4x4f();
        tempMatrix.translateBy(0, 0, 1);
        
        
        if(textureOn){
        	if(!texturePath.get(0).equals("none"))
        	{
        		t[0].enable();
        		t[0].bind();
        	}
        	glu.gluDisk(quadric, 0, 0.5, 20, 10);
        	if(!texturePath.get(0).equals("none"))
        	{
        		t[0].disable();
        		t[0].dispose();
        	}
        	if(!texturePath.get(1).equals("none"))
        	{
        		t[1].enable();
        		t[1].bind();
        	}
        	glu.gluCylinder(quadric, 0.5, 0.5, 1.0, 20, 20);
        	if(!texturePath.get(1).equals("none"))
        	{
        		t[1].disable();
        		t[1].dispose();
        	}
        	if(!texturePath.get(2).equals("none"))
        	{
        		t[2].enable();
        		t[2].bind();
        	}
            gl.glMultMatrixf(tempMatrix.getMatrix(), 0);
            glu.gluDisk(quadric, 0, 0.5, 20, 10);
        	if(!texturePath.get(2).equals("none"))
        	{
        		t[2].disable();
        		t[2].dispose();
        	}
        }
        else{
            glu.gluDisk(quadric, 0, 0.5, 20, 10);
            glu.gluCylinder(quadric, 0.5, 0.5, 1.0, 20, 20);
            gl.glMultMatrixf(tempMatrix.getMatrix(), 0);
            glu.gluDisk(quadric, 0, 0.5, 20, 10);
        }
    }
}
