package model;

import java.io.PrintWriter;
import java.util.*;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import com.sun.opengl.util.GLUT;


public class PrimitiveCube extends PrimitiveObject {
    /**
     * Each face of the cube has four vertices. These are the indexes
     * of those vertices in the vertices array.
     */
    private int[][] faces = 
            {{ 0, 1, 3, 2 },    // negative z
             { 0, 1, 5, 4 },    // negative y
             { 0, 2, 6, 4 },    // negative x
             { 1, 3, 7, 5 },    // positive x
             { 2, 3, 7, 6 },    // positive y
             { 4, 5, 7, 6 }};   // positive z
    
    /**
     * The corresponding normal vectors for each cube face.
     */
    private int[][] normals =
            {{ 0, 0, -1 },      // negative z
             { 0, -1, 0 },      // negative y
             { -1, 0, 0 },      // negative x
             { 1, 0, 0 },       // positive x
             { 0, 1, 0 },       // positive y
             { 0, 0, 1 }};      // positive z
    float[][][] cubTexPnts;
    
    public PrimitiveCube(Model model) {
        super(model);
        //originalVertices = new float[8][4];
        vertices = new float[][]
        	{{0f, 0f, 0f, 1f},
        	 {1f, 0f, 0f, 1f},
        	 {0f, 1f, 0f, 1f},
        	 {1f, 1f, 0f, 1f},
        	 {0f, 0f, 1f, 1f},
        	 {1f, 0f, 1f, 1f},
        	 {0f, 1f, 1f, 1f},
        	 {1f, 1f, 1f, 1f}};
        computedVertices = new float[8][4];
        objectType.setObjType("PrimitiveCube");
        while(texturePath.size() < 6)
            texturePath.add("none");
        
        cubTexPnts = new float[6][4][2];
        
        for(int k = 0; k <6; k++)
            for(int i=0; i<4; i++)
                for(int j=0; j<2; j++)
                    cubTexPnts[k][i][j] = 0.0f;
        
        for(int i = 0; i < 6; i++){
            if(!(i == 2 || i == 4)){
                cubTexPnts[i][1][0] = 1.0f;
                cubTexPnts[i][2][0] = 1.0f;
                cubTexPnts[i][2][1] = 1.0f;
                cubTexPnts[i][3][1] = 1.0f;
            }
            else{
                cubTexPnts[i][0][0] = 1.0f;
                cubTexPnts[i][2][1] = 1.0f;
                cubTexPnts[i][3][1] = 1.0f;
                cubTexPnts[i][3][0] = 1.0f;
            }
        }
    }
    
    protected void readInPrimitive(Scanner scanner){
        // nothing special for a cube, just the normal PrimitiveObject data members
    }
    
    protected void writeOutPrimitive(PrintWriter writer){
        // nothing special for a cube, just the normal PrimitiveObject data members
    }
    
    /**
     * Draws the cube to the current gl list.
     */
    protected void drawToList(GL gl, GLU glu, GLUT glut){
        glCalculated = true;
        
        for(int i=0; i<faces.length; i++){
            
            if(textureOn && !texturePath.get(i).equals("none")){
            	t[i].enable();
            	t[i].bind();  
            }
            
            gl.glBegin(GL.GL_POLYGON);
            gl.glNormal3d(normals[i][0], normals[i][1], normals[i][2]);
                for(int j=0; j<faces[i].length; j++){
                	if(textureOn && !texturePath.get(i).equals("none")){
                		
                			gl.glTexCoord2f(cubTexPnts[i][j][0],cubTexPnts[i][j][1]);
                	}
                    gl.glVertex3d(vertices[faces[i][j]][0],
                                  vertices[faces[i][j]][1],
                                  vertices[faces[i][j]][2]);}
            gl.glEnd();
            gl.glEnable(GL.GL_NORMALIZE); 
            if(textureOn && !texturePath.get(i).equals("none")){
                t[i].disable();
            	t[i].dispose();
            }
        }
    }
}
