package model;

import java.io.PrintWriter;
import java.util.*;
import javax.media.opengl.*;
import javax.media.opengl.glu.*;
import com.sun.opengl.util.*;

public class PrimitiveCone extends PrimitiveObject {
    
    //private double baseCenterX, baseCenterY, radius, height;
    
    public PrimitiveCone(Model model) {
        super(model);
        vertices = new float[0][0];
        computedVertices = new float[0][0];
        objectType.setObjType("PrimitiveCone");
        while(texturePath.size() < 2)
        	texturePath.add("none");
    }
    
    protected void readInPrimitive(Scanner scanner){
        
    }
    
    protected void writeOutPrimitive(PrintWriter writer){
        
    }
    
    /**
     * Draws the cone to the current gl list.
     */
    protected void drawToList(GL gl, GLU glu, GLUT glut){
        glCalculated = true;
        
        
        GLUquadric quadric = glu.gluNewQuadric();
        glu.gluQuadricDrawStyle(quadric, GLU.GLU_FILL);
        glu.gluQuadricNormals(quadric, GLU.GLU_SMOOTH);
        
        if(textureOn){
        	if(!texturePath.get(0).equals("none")){
        		t[0].enable();
        		t[0].bind();
        		glu.gluQuadricTexture(quadric, textureOn);
        	}
        	glu.gluDisk(quadric, 0, 0.5, 20, 10);
        	if(!texturePath.get(0).equals("none")){
        		t[0].disable();
        		t[0].dispose();
        		glu.gluQuadricTexture(quadric, false);
        	}
        	if(!texturePath.get(1).equals("none")){
        		t[1].enable();
        		t[1].bind();
        		glu.gluQuadricTexture(quadric, textureOn);
        	}
        	glu.gluCylinder(quadric, 0.5, 0.0, 1.0, 20, 20);
        	if(!texturePath.get(1).equals("none")){
        		t[1].disable();
        		t[1].dispose();
        		glu.gluQuadricTexture(quadric, false);
        	}
        }
        

        else{
        glu.gluDisk(quadric, 0, 0.5, 20, 10);
        glu.gluCylinder(quadric, 0.5, 0.0, 1.0, 20, 20);
        }
        
    }
}
