package model;

import java.util.*;
import java.io.*;

/**
 * Used by Model for easy file I/O. When reading in model files, ignores
 * comment lines (designated by a "#" at the beginning).
 */
public class ModelFile {
    /*
    class Comment{
        String comment;
        int lineNum;
        boolean ownLine;
        
        public Comment(String c, int line, boolean own){
            comment = c;
            lineNum = line;
            ownLine = own;
        }
    }
    */
    
    //private int curLineNum;
    //private ArrayList<Comment> comments;
    private boolean endOfObject;
    private boolean endOfFile;
    private Scanner scanner;
    
    public ModelFile(){
        //curLineNum = 0;
        //comments = new ArrayList<Comment>();
        endOfObject = false;
        endOfFile = false;
    }
    public ModelFile(Scanner scanner){
        this();
        this.scanner = scanner;
    }
    
    /*
    public void addComment(String comment, boolean ownLine){
        Comment c = new Comment(comment, curLineNum, ownLine);
        comments.add(c);
    }
    */
    
    public boolean isEndOfFile(){
        return endOfFile;
    }
    public void startNewFile(Scanner scanner){
        this.scanner = scanner;
        endOfObject = false;
        endOfFile = false;
    }
    public boolean isEndOfObject(){
        return endOfObject;
    }
    public void startNewObject(){
        endOfObject = false;
    }
    
    public void writeString(PrintWriter pw, String s){
        pw.println(s);
    }
    public void writeFloatArray(PrintWriter pw, float[] arr){
        for(int i=0; i<arr.length-1; i++)
            pw.print(arr[i] + " ");
        if(arr.length > 0)
            pw.println(arr[arr.length-1]);
    }
    
    public String readObjectTypeString(){
        if(endOfFile)
            return "";
        
        startNewObject();
        
        String temp;
        do{
            temp = readLine();
        }
        while(!endOfFile && !temp.matches("[oO][bB][jJ][eE][cC][tT][tT][yY][pP][eE]: .*"));
        
        if(endOfFile)
            return "";
        else
            return temp.substring(12).trim();
    }
    
    public String readString(){
        if(endOfObject)
            return "";
        
        //curLineNum++;
        return readLine();
    }
    
    public int readInt(){
        if(endOfObject)
            return 0;
        
        //curLineNum++;
        String temp = readLine();
        
        return Integer.parseInt(temp);
    }
    public int[] readIntArray(){
        if(endOfObject)
            return new int[0];
        
        String[] tempSplit = readLine().split("\\s+");
        
        int[] a = new int[tempSplit.length];
        int lastIndex = 0;
        for(int i=0; i<tempSplit.length; i++){
            try{
                a[lastIndex] = Integer.parseInt(tempSplit[i]);
                lastIndex++;
            }catch(NumberFormatException e){}
        }
        
        int[] arr = new int[lastIndex];
        System.arraycopy(a, 0, arr, 0, lastIndex);
        
        return arr;
    }
    public int[] readNInts(int n){
        if(endOfObject)
            return new int[n];
        
        String[] tempSplit = readLine().split("\\s+");
        
        int[] a = new int[n];
        int lastIndex = 0;
        for(int i=0; i<Math.min(tempSplit.length, n); i++){
            try{
                a[lastIndex] = Integer.parseInt(tempSplit[i]);
                lastIndex++;
            }catch(NumberFormatException e){}
        }
        
        return a;
    }
    
    public float readFloat(){
        if(endOfObject)
            return 0f;
        
        //curLineNum++;
        String temp = readLine();
        
        return Float.parseFloat(temp);
    }
    public float[] readFloatArray(){
        if(endOfObject)
            return new float[0];
        
        String[] tempSplit = readLine().split("\\s+");
        
        float[] a = new float[tempSplit.length];
        int lastIndex = 0;
        for(int i=0; i<tempSplit.length; i++){
            try{
                a[lastIndex] = Float.parseFloat(tempSplit[i]);
                lastIndex++;
            }catch(NumberFormatException e){}
        }
        
        float[] arr = new float[lastIndex];
        System.arraycopy(a, 0, arr, 0, lastIndex);
        
        return arr;
    }
    public float[] readNFloats(int n){
        if(endOfObject)
            return new float[n];
        
        String[] tempSplit = readLine().split("\\s+");
        
        float[] a = new float[n];
        int lastIndex = 0;
        for(int i=0; i<Math.min(tempSplit.length, n); i++){
            try{
                a[lastIndex] = Float.parseFloat(tempSplit[i]);
                lastIndex++;
            }catch(NumberFormatException e){}
        }
        
        return a;
    }
    
    private String readLine(){
        String temp = "";
        boolean isComment = false;
        int indexOfSplit;
        
        if(scanner.hasNextLine()){
            do{
                temp = scanner.nextLine().trim();
                if(temp.substring(0, 1).equals("#")){
                    isComment = true;
                    //addComment(temp.substring(1).trim(), true);
                }
                else{
                    isComment = false;
                    indexOfSplit = temp.indexOf('#');
                    if(indexOfSplit > 0){
                        //addComment(temp.substring(indexOfSplit+1).trim(), false);
                        temp = temp.substring(0, indexOfSplit).trim();
                    }
                }
            }
            while(scanner.hasNextLine() && isComment);
        }
        
        if(temp.equalsIgnoreCase("EndObject")){
            temp = "";
            endOfObject = true;
        }
        if(!scanner.hasNextLine()){
            endOfObject = true;
            endOfFile = true;
        }
        
        if(isComment)
            return "";
        else
            return temp;
    }
}
