package model;

import java.util.*;

/**
 * Maintains unique IDs for each object in a model/complex object.
 */
public class IDList {
    private static final int ORIGINAL_SIZE = 100;
    
    private ComplexObject[] list;
    private ArrayList<Integer> freeIDs;
    
    public IDList(){
        list = new ComplexObject[ORIGINAL_SIZE];
        freeIDs = new ArrayList<Integer>(ORIGINAL_SIZE);
        
        for(int i=0; i<ORIGINAL_SIZE; i++)
            freeIDs.add(new Integer(i));
    }
    
    public ComplexObject get(int index){
        if(index < 0 || index > list.length)
            return null;
        return list[index];
    }
    
    public void add(ComplexObject co){
        if(freeIDs.size()==0)
            incListSize();
        
        int curID = freeIDs.remove(0).intValue();
        co.setID(curID);
        list[curID] = co;
    }
    
    public ComplexObject remove(int index){
        if(index < 0 || index > list.length || list[index] == null)
            return null;
        
        ComplexObject co = list[index];
        list[index] = null;
        freeIDs.add(index);
        
        return co;
    }
    
    private void incListSize(){
        ComplexObject[] list2 = new ComplexObject[list.length*2];
        System.arraycopy(list, 0, list2, 0, list.length);
        
        for(int i=list.length; i<list2.length; i++)
            freeIDs.add(new Integer(i));
    }
}
