package model;

import java.io.*;
import java.util.*;

import javax.media.opengl.*;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;

public class ComplexObject {
    protected ArrayList<ComplexObject> objects;
    protected IDList objectIDList;
    protected Transformation transformation;
    protected boolean glCalculated;
    protected boolean overwriteChildColors;
    protected ObjectType objectType;
    protected float[] fillColor;
    protected int priority;
    protected int id;
    protected String alias;
    protected Model model;
    protected ArrayList<String> texturePath;
    protected boolean textureOn;
    protected float[][] texPoints;
    protected Texture[] t;
    protected TextureData[] td;
    
    
    public ComplexObject(Model model){
        objects = new ArrayList<ComplexObject>();
        objectIDList = new IDList();
        transformation = new Transformation();
        glCalculated = false;
        objectType = new ObjectType(model);
        objectType.setObjType("Complex");
        priority = 2;
        this.model = model;
        setAlias("");
        fillColor = new float[]{1f, 1f, 1f, 1f};
        overwriteChildColors = false;
        textureOn = true;
		t = new Texture[32];
		td = new TextureData[32];
    }
  
    /**
     * Creates a deep copy of this complex object.
     * Everything is the same except for the Model.
     * @param m	The Model assignment for the new ComplexObject
     * @return a copy of the complex object
     */
    public ComplexObject copy(Model m) {
    	ObjectType newType = objectType.copy(m);
    	ComplexObject newCO = newType.getObjectOf(newType.getObjType());
    	
    	//ComplexObject newCO = new PrimitiveObject(m);
    	ComplexObject t;
 
    	
        //newCO.setAlias("Copy of " + alias);
        //newCO.setAlias("Copy of " + alias + " " + System.nanoTime());
        newCO.setAlias(alias);
        
    	//Set up objects
    	newCO.objectIDList = new IDList();    	
    	newCO.objects = new ArrayList<ComplexObject>();
    	for (ComplexObject c : this.objects) {
    		t = c.copy(m);
    		newCO.objects.add(t);
    		newCO.objectIDList.add(t);
    	}
    	
    	//Set up transformation
        newCO.setTransform(transformation.getTransformation());        
        newCO.glCalculated = false;
        newCO.objectType = newType;
        newCO.priority = priority;
        newCO.overwriteChildColors = overwriteChildColors;
        
        //Set up texture stuff
        newCO.textureOn = textureOn;        
        newCO.texturePath = new ArrayList<String>();
        if(texturePath != null){
            for (String s : this.texturePath) {
            	newCO.texturePath.add(new String(s));
            }
            if(texPoints != null){
                newCO.texPoints = new float[this.texPoints.length][this.texPoints[0].length];
                for (int i = 0; i < this.texPoints.length; i++) {
                	System.arraycopy(this.texPoints[i], 0, 
                					 newCO.texPoints[i], 0, 
                					 this.texPoints[i].length);
                }
                newCO.t = this.t.clone();
                newCO.td = this.td.clone();
            }
        }
        
        //Set up color
        newCO.fillColor = this.getFillColor();
        
        //TODO: Check on ID and priority!
    	
    	return newCO;
    }
    
    public boolean getGlCalculated(){
        return glCalculated;
    }
    
    public int getID(){
        return id;
    }
    public void setID(int id) {
        this.id = id;
    }
    
    public boolean getOverwriteChildColors(){
        return overwriteChildColors;
    }
    public void setOverwriteChildColors(boolean o) {
        overwriteChildColors = o;
    }
    
    public String getAlias(){
        return alias;
    }
    public void setAlias(String alias){
        this.alias = alias;
    }
    
    public ObjectType getObjectType(){
        return objectType;
    }
    public void setObjectType(ObjectType objectType){
        this.objectType = objectType;
    }
    public void setComplexType(String type) {
    	this.objectType.setComplexType(type);
    }
    
    /**
     * Returns a deep copy of this fill color.
     * @return color
     */
    public float[] getFillColor() {
    	float[] newColor = new float[fillColor.length];
    	System.arraycopy(fillColor, 0, newColor, 0, fillColor.length);
        return newColor;
    }
    public void setFillColor(float red, float green, float blue, float alpha) {
    	glCalculated = false;
        
        fillColor[0] = red;
        fillColor[1] = green;
        fillColor[2] = blue;
        fillColor[3] = alpha;
        
        if(overwriteChildColors){
            for(ComplexObject co : objects){
                co.setFillColor(red, green, blue, alpha);
            }
        }
    }
    
    public void setFillColor(float[] color){
    	glCalculated = false;
        
        if(color.length == fillColor.length)
            System.arraycopy(color, 0, fillColor, 0, fillColor.length);
        
        if(overwriteChildColors){
            for(ComplexObject co : objects){
                co.setFillColor(color);
            }
        }
    }
    
    /**
     * Just a stub, since we're not allowing textures on ComplexObjects, just Primitives.
     */
    public void setTexturesOn(boolean b){}
    
    /*
     * Following added by Debbie
     */
    /**
     * Added by Debbie.
     * Accesses this ComplexObject's list of interior objects.
     * @return list of objects
     */
    public ArrayList<ComplexObject> getObjectList(){
        return objects;
    }
    /**
     * Added by Debbie.
     * Mutates this ComplexObject's list of interior objects.
     * @param list New list of interior objects
     */
    public void setObjectList(ArrayList<ComplexObject> list){
        objects = list;
    }
    /**
     * Added by Debbie.
     * Accesses the IDList for this ComplexObject's interior objects..
     * @return list of ObjectIDs
     */
    public IDList getObjectIDList() {
        return objectIDList;
    }
    /**
     * Added by Debbie.
     * Mutates the IDList for this ComplexObject's interior objects.
     */
    public void setObjectIDList(IDList objectIDList) {
        this.objectIDList = objectIDList;
    }
    /**
     * Added by Debbie.
     * Accesses the transformation matrix as a Matrix4x4f.
     * @return transformation matrix
     */
    public Transformation getTransformation() {
    	return transformation;
    }
    /**
     * Added by Debbie.
     * Accesses the transformation matrix as a float array.
     * @return transformation matrix as float[]
     */
    public float[] getTransMatrixFloat() {
    	return transformation.getTransMatrix().getMatrix();
    }
    
    public int getPriority() {
        return priority;
    }
    public void setPriority(int priority) {
        this.priority = priority;
    }
    
    public void load(ModelFile mf){
        glCalculated = false;
        
        mf.startNewObject();
        setAlias(mf.readString());
        setPriority(mf.readInt());
        setFillColor(mf.readNFloats(4));
        transformation = new Transformation();
        transformation.transformTo(mf.readNFloats(3),
                mf.readNFloats(3), mf.readNFloats(3));
    }
    
    public void write(PrintWriter writer, ModelFile mf){
        mf.writeString(writer, alias);
        mf.writeString(writer, ""+priority);
        mf.writeFloatArray(writer, fillColor);
        
        mf.writeFloatArray(writer, transformation.getTranslation());
        mf.writeFloatArray(writer, transformation.getRotation());
        mf.writeFloatArray(writer, transformation.getScale());
    }
    
    public void draw(boolean forceRender){
        glCalculated = true;
        GL gl = model.getGL();
        
        gl.glPushMatrix();
        
        // what the heck is the second parameter?
        gl.glMultMatrixf(transformation.getTransMatrix().getMatrix(), 0); 
        
        for(ComplexObject o : objects){
            o.draw(forceRender);
        }
        
        // now that we're out of the scope of these transformations,
        // let's set the transformation matrix back to what it was
        
        gl.glPopMatrix();
        
    }
    
    // transformation methods changed to use transformationMatrix
    // for now just taking a whole transformation matrix as the parameter
    public void transformBy(Matrix4x4f m){
        glCalculated = false;
        transformation.getTransMatrix().multMatrix(m);
    }
    public void transformBy(float[] m){
        glCalculated = false;
        transformation.getTransMatrix().multMatrix(m);
    }
    public void setTransform(Matrix4x4f m){
        glCalculated = false;
        transformation.getTransMatrix().setMatrix(m);
    }
    public void setTransform(float[] m){
        glCalculated = false;
        transformation.getTransMatrix().setMatrix(m);
    }
    public void setTransform(Transformation t) {
    	glCalculated = false;
    	transformation = t;
    }
    
    /*
    public void setTranslation(float transX, float transY, float transZ){
        transMatrix.setTranslation(transX, transY, transZ);
    }
    */
    public void translateBy(float transX, float transY, float transZ){
        glCalculated = false;
        transformation.translateBy(transX, transY, transZ);
    }
    public void scaleBy(float scaleX, float scaleY, float scaleZ){
        glCalculated = false;
        transformation.scaleBy(scaleX, scaleY, scaleZ);
    }
    public void rotateBy(float rotX, float rotY, float rotZ){
        glCalculated = false;
        transformation.rotateBy(rotX, rotY, rotZ);
    }
    
    public void transformBy(float[] trans, float[] rot, float[] scale) {
    	glCalculated = false;
    	transformation.transformBy(trans, rot, scale);
    }
    
    //Transforms to
    public void translateTo(float transX, float transY, float transZ){
        glCalculated = false;
        transformation.translateTo(transX, transY, transZ);
    }
    public void scaleTo(float scaleX, float scaleY, float scaleZ){
        glCalculated = false;
        transformation.scaleTo(scaleX, scaleY, scaleZ);
    }
    public void rotateTo(float rotX, float rotY, float rotZ){
        glCalculated = false;
        transformation.rotateTo(rotX, rotY, rotZ);
    }
    
    public void transformTo(float[] trans, float[] rot, float[] scale) {
    	glCalculated = false;
    	transformation.transformTo(trans, rot, scale);
    }

    /**
     * Store the filename of the texture for the specified face
     * @param i	 face #
     * @param s	filename of texture
     */
    public void setTexturePath(int i, String s){
    	glCalculated = false;
    	texturePath.remove(i);
    	texturePath.add(i,s);
    }
    /**
     * Clears all texture info from this object.
     */
    public void clearTexturePath() {
    	int numSides = texturePath.size();
    	texturePath = new ArrayList<String>();
    	for (int i = 0; i < numSides; i++) {
    		texturePath.add("none");
    	}
    	glCalculated = false;
    }    
    
    /**
     * Sets the texture of the specified face to the specified image
     * @param face	number corresponding to face
     * @param filename	filename of texture to be mapped to that face
     */
    public void updateTexture(int face, String filename){
    	glCalculated = false;
    	try{
    		td[face] =  TextureIO.newTextureData(new File(viewer.Viewer.getDataPath() + "textures/"  + filename),true, filename.substring(filename.length() - 3) );
    	}
    	catch (IOException e) {
            e.printStackTrace();
        }
    }
    /*
     * @return	the # of textures this object can have
     */
    public int getTexSize(){
    	return texturePath.size();
    }
    /*
     * Returns the filename of the specified face
     * @param i	number of face
     * @return	file name of texture
     */
    public String getTexPath(int i){
    	return texturePath.get(i);
    }
    

    /**
     * Sets the textures for this object to numbered panels.
     * This is intended to aid the designer, who may not know which
     * face of the building corresponds to which number.
     */
    public void setTexturesToNumbers() {
    	glCalculated = false;
    	setTexture("zero.jpg one.jpg two.jpg three.jpg four.jpg five.jpg");
    }
 
    /*
     * This method sets up the inital textures when an object is loaded from a file.
     * The textures for all the faces are read in as one string assigned to the appropriate
     * face
     * @param texture	name of texture image file (located in basec/textures/
     */
    public void setTexture(String texture){
    	
		
		if(textureOn){
		    
			texturePath = new ArrayList<String>();
			
    		Scanner scan = new Scanner(texture);
    		
    		
    		while(scan.hasNext()){
    			texturePath.add(scan.next());
    		}
    		
            texPoints = new float[4][2];
            for(int i=0; i<4; i++)
                 for(int j=0; j<2; j++)
                     texPoints[i][j] = 0.0f;
            
            texPoints[1][0] = 1.0f;
            texPoints[2][0] = 1.0f;
            texPoints[2][1] = 1.0f;
            texPoints[3][1] = 1.0f;
            
            try {
				for(int i = 0;i<texturePath.size();i++){
					if(!texturePath.get(i).equals("none")){
						td[i] = TextureIO.newTextureData(new File(viewer.Viewer.getDataPath() + "textures/" + texturePath.get(i)),true, texturePath.get(i).substring(texturePath.get(i).length() - 3) );
						
						//System.err.println(t[i].getEstimatedMemorySize());
					}
				}
            }
            catch (GLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
