#!/usr/bin/perl

# This script imports raw tcpdump data into the database, making it look to Titan
# as if new packets have come in across the network. Thus, this script makes
# testing Titan on large amounts of network traffic in a short time fun, free, and easy.

# edit these as necessary
$packets_file = 'outside.tcpdump'; # file of tcpdump data...the source for packet information
$database = "ulogd"; # MySQL database
$dbusername = "ulogd"; # MySQL username
$dbpassword = "!*reSear"; # MySQL password
$table = "ulog"; # table to insert packets into

# Don't touch this unless you know what you're doing...we're serious.
$packets_command = "tcpdump -tttt -nn -v -r $packets_file | grep IP";

use DBI;

my $dbh = DBI->connect("DBI:mysql:$database", $dbusername, $dbpassword);

# insert each packet into the database
open PACKETS, "$packets_command |";
$i = 1;
while (<PACKETS>) {
	# parse packet information
	/^(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}).*?\(.*?, ttl\s+(\d+),.*?proto (\d+),\s+length:\s+(\d+)\)\s+(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})\.?(\d+)? > (\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})[\.:](\d+)?/;
	my $time = $1;
	my $ttl = $2;
	my $protocol = $3;
	my $length = $4;
	my $sip = $5;
	my $sport = $6;
	my $dip = $7;
	my $dport = $8;
	my @ip = split /\./, $sip;
        my $ipsaddr = $ip[0]*16777216 + $ip[1]*65536 + $ip[2]*256 + $ip[3];
	@ip = split /\./, $dip;
        my $ipdaddr = $ip[0]*16777216 + $ip[1]*65536 + $ip[2]*256 + $ip[3];

	#print "Source IP: $sip ($ipsaddr)\n";
	#print "Destination IP: $dip ($ipdaddr)\n";
	#print "Source port: $sport\n";
	#print "Destination port: $dport\n";
	#print "Time: $time\n";

	# begin building our insert query...
	# these things here apply to all packets
	my $query = "insert into $table set "
		. " oob_time_sec = unix_timestamp('$time'), ip_saddr='$ipsaddr'"
		. ", ip_daddr='$ipdaddr', ip_protocol='$protocol' "
		. ", ip_totlen='$length', ip_ttl='$ttl' ";
	
	# add more to our query, as required by various protocols
	if($protocol == 1) #icmp
	{
		# :-)
	}
	elsif($protocol == 6) #tcp
	{
		my ($tcp_psh, $tcp_rst, $tcp_syn, 
			 $tcp_fin, $tcp_ack, $tcp_urg);

		$tcp_psh = $tcp_rst = $tcp_syn = $tcp_fin = $tcp_ack = $tcp_urg = 0;

		# parse TCP flags
		/: ([\.A-Z]+) [tcp sum ok]/;
		$tcp_psh = 1 if $1 =~ /P/;
		$tcp_rst = 1 if $1 =~ /R/;
		$tcp_syn = 1 if $1 =~ /S/;
		$tcp_fin = 1 if $1 =~ /F/;
		$tcp_ack = 1 if / ack \d+/;
		$tcp_urg = 1 if / urg /;
		
		# add good TCP stuff to our insert query
		$query .= ", tcp_sport='$sport', tcp_dport='$dport' "
		. ", tcp_psh='$tcp_psh', tcp_rst='$tcp_rst', tcp_syn='$tcp_syn' "
		. ", tcp_fin='$tcp_fin', tcp_ack='$tcp_ack', tcp_urg='$tcp_urg'";
	}
	elsif($protocol == 17) #udp
	{
		# only one thing to add for UDP packets...the source port
		$query .= ", udp_sport='$sport'";
	}

	#do query
	my $j = $dbh->prepare($query);
	$j->execute;
}

