#!/usr/bin/perl

# This script imports scored connections, so that Titan can have
# some connections to compare new connections to. You have to start somewhere.

# settings
# edit these lines as necessary
$connections_file = 'tcpdump.list'; # the connections file
$packets_file = 'outside.tcpdump'; # the file containing tcpdump data...the source for packet information
$database = "ulogd"; # MySQL database
$dbusername = "ulogd"; # MySQL username
$dbpassword = "!*reSear"; # MySQL password
$table = "connections_training_week1"; # table to insert connection information into
$time_offset = 4;  #the time difference between connection files and tcpdump timestamps, in hours.

# don't edit this, unless you really think you know what you're doing
$packets_command = "tcpdump -tttt -nn -v -r $packets_file | grep IP";

use DBI;

$dbh = DBI->connect("DBI:mysql:$database", $dbusername, $dbpassword);

# add all connections (with scores) to the table specified by $table
open CONNECTIONS, $connections_file;
while (<CONNECTIONS>) {
	# read the connection information and parse it
	my @line = split;
	my @ip = split /\./, $line[7];
	my $ipsaddr = $ip[0]*16777216 + $ip[1]*65536 + $ip[2]*256 + $ip[3];
	@ip = split /\./, $line[8];
	my $ipdaddr = $ip[0]*16777216 + $ip[1]*65536 + $ip[2]*256 + $ip[3];
	my @t = split /:/, $line[3];
	my $seclength = $t[0]*3600 + $t[1]*60 + $t[2];
	my $protocol = 6;
	if ($line[4] =~ /\/i$/) {
		$protocol = 1;
	} elsif ($line[4] =~ /\/u$/) {
		$protocol = 17;
	}
	
	#reverse the scoring
	if($line[9] == 0) { $line[9] = 1;}
	else { $line[9] = 0;} 

	# insert the connection into the database
	my $query = "insert into $table set protocol='$protocol', ip_saddr='$ipsaddr', ip_daddr='$ipdaddr'";
	$query .= ", sport='$line[5]', dport='$line[6]', score='$line[9]', open='NO', currently_scored='YES'";
	$query .= ", time_established=str_to_date('$line[1] $line[2]', '%m/%d/%Y %T')";
	$query .= ", time_closed=date_add(str_to_date('$line[1] $line[2]', '%m/%d/%Y %T'), interval $seclength second)";
	my $j = $dbh->prepare($query);
	$j->execute;
}
close CONNECTIONS;

# add individual packets to the connections we just imported
open PACKETS, "$packets_command |";
$i = 1;
while (<PACKETS>) {
	# parse packet information
	/^(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}).*?\(.*?, ttl\s+(\d+),.*?proto (\d+),\s+length:\s+(\d+)\)\s+(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})\.?(\d+)? > (\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})[\.:](\d+)?/;
	my $time = $1;
	my $ttl = $2;
	my $protocol = $3;
	my $length = $4;
	my $sip = $5;
	my $sport = $6;
	my $dip = $7;
	my $dport = $8;
	my @ip = split /\./, $sip;
        my $ipsaddr = $ip[0]*16777216 + $ip[1]*65536 + $ip[2]*256 + $ip[3];
	@ip = split /\./, $dip;
        my $ipdaddr = $ip[0]*16777216 + $ip[1]*65536 + $ip[2]*256 + $ip[3];

	#print "Source IP: $sip ($ipsaddr)\n";
	#print "Destination IP: $dip ($ipdaddr)\n";
	#print "Source port: $sport\n";
	#print "Destination port: $dport\n";
	#print "Time: $time\n";

	# modify the connection appropriately that this packet belongs to
	if ($protocol == 1) { # for ICMP packets
		# identify which connection this packet belongs to
		my $query = "select connection_id from connections_training_week1 where";
		$query .= " (ip_saddr='$ipsaddr' and ip_daddr='$ipdaddr')";
		$query .= " or (ip_saddr='$ipdaddr' and ip_daddr='$ipsaddr')";
		$query .= " and protocol=1";
		$query .= " and time_established<=date_sub('$time', interval $time_offset hour) and time_closed>=date_sub('$time', interval $time_offset hour)";
		my $j = $dbh->prepare($query);
		$j->execute;
		my $r = $j->fetchrow_hashref;
		# if we find a matching existing connection, update that connection's statistics
		if ($r->{connection_id}) {
			$query = "update connections_training_week1 set";
			$query .= " num_packets=num_packets+1, time_last_packet=date_sub('$time', interval $time_offset hour)";
			$query .= " where connection_id=$r->{connection_id}";
			$j = $dbh->prepare($query);
			$j->execute;
		} else {
			#print "No matching connection for packet:\n\t$_";
		}
	} elsif ($protocol == 17) { # for UDP packets
		# identify which connection this packet belongs to
		my $query = "select connection_id from connections_training_week1 where";
		$query .= " (ip_saddr='$ipsaddr' and ip_daddr='$ipdaddr')";
		$query .= " or (ip_saddr='$ipdaddr' and ip_daddr='$ipsaddr')";
		$query .= " and protocol=17";
		$query .= " and time_established<=date_sub('$time', interval $time_offset hour) and time_closed>=date_sub('$time', interval $time_offset hour)";
		my $j = $dbh->prepare($query);
                $j->execute;
                my $r = $j->fetchrow_hashref;
		# if we find a matching existing connection, update that connection's statistics
                if ($r->{connection_id}) {
                        $query = "update connections_training_week1 set";
                        $query .= " num_packets=num_packets+1, time_last_packet=date_sub('$time', interval $time_offset hour)";
			$query .= ", packet_length=(packet_length*num_packets+'$length')/(num_packets+1)";
			$query .= " where connection_id=$r->{connection_id}";
			$j = $dbh->prepare($query);
			$j->execute;
                } else {
                        #print "No matching connection for packet:\n\t$_";
                }
	} elsif ($protocol == 6) { # for TCP packets
		# identify which connection this packet belongs to
		my $query = "select connection_id from connections_training_week1 where";
		$query .= " (ip_saddr='$ipsaddr' and ip_daddr='$ipdaddr' and sport='$sport' and dport='$dport')";
		$query .= " or (ip_saddr='$ipdaddr' and ip_daddr='$ipsaddr' and sport='$dport' and dport='$sport')";
		$query .= " and protocol=6";
		$query .= " and time_established<=date_sub('$time', interval $time_offset hour) and time_closed>=date_sub('$time', interval $time_offset hour)";
		#print "Query: $query\n";
		my $j = $dbh->prepare($query);
		$j->execute;
		my $r = $j->fetchrow_hashref;
		# if we find a matching existing connection, update that connection's statistics
		if ($r->{connection_id}) {
			my ($tcp_psh, $tcp_rst, $tcp_syn, $tcp_syn, $tcp_fin, $tcp_ack, $tcp_urg);
			# figure out which TCP flags are set
			/: ([\.A-Z]+) [tcp sum ok]/;
			$tcp_psh = 1 if $1 =~ /P/;
			$tcp_rst = 1 if $1 =~ /R/;
			$tcp_syn = 1 if $1 =~ /S/;
			$tcp_fin = 1 if $1 =~ /F/;
			$tcp_ack = 1 if / ack \d+/;
			$tcp_urg = 1 if / urg /;
			# run the update query
			$query = "update connections_training_week1 set";
			$query .= " num_packets = num_packets + 1";
			$query .= ", packet_ttl=(packet_ttl*num_packets+'$ttl')/(num_packets+1)";
			$query .= ", packet_length=(packet_length*num_packets+'$length')/(num_packets+1)";
			$query .= ", tcp_urg=tcp_urg+'$tcp_urg', tcp_ack=tcp_ack+'$tcp_ack'";
			$query .= ", tcp_psh=tcp_psh+'$tcp_psh', tcp_rst=tcp_rst+'$tcp_rst'";
			$query .= ", tcp_syn=tcp_syn+'$tcp_syn', tcp_fin=tcp_fin+'$tcp_fin'";
			$query .= ", time_last_packet=date_sub('$time', interval $time_offset hour) where connection_id=$r->{connection_id}";
			#print "Update query: $query\n";
			my $j = $dbh->prepare($query);
			$j->execute;
		} else {
			#print "No matching connection for packet:\n\t$_";
		}
	} else { # all other protocols
		print "A protocol we don't want to touch: $_";
	}
	# helpful progress report
	print "Packet $i processed.\n" if $i % 10000 == 0;
	$i++;
}
close PACKETS;
