#include <mysql/mysql.h>

#define host "localhost"
#define username "ulogd"
#define password "!*reSear"
#define database "ulogd"
#define kNULLRep "NULL"
#define kSuccess "Success"
#define kMaxResults 20 //maximum number of query results that may be
			//in memory at a time

//sql_data_t is an array of strings, indexed 2-dimensionally.
//to get field i of row j, use dataset[j*nfiels + i]
typedef char ** sql_data_t;

class Db_Query {
	public:
	  Db_Query();	//connects to the database on construction
	  ~Db_Query();
	  int query(char * query, int len);	//executes a query and ignores the results.  returns 1 on success,
						// and 0 on failure
	  const sql_data_t query(char * query, int len, int *nr, int *nf); //executes a query
					//returns the results on success, NULL on failure

	  bool isValid();	//true if the Db_Query has a valid database connection

	  const char * getError(); //returns the text of the last sql error to occur

	  sql_data_t release(sql_data_t dataset);  //frees the memory associated with this dataset, only if it
							//was created by this Db_Query and not yet released.
							//returns dataset on failure, NULL on success

	  bool ready();		//true if the Db_Query can perform a query.  
				//Equivalent to (isValid && numResults <= kMaxResults)
	
	private:
	  void open();
	  void close();
	  MYSQL *conn;
	  bool valid;
	  const char * error;
	  sql_data_t storedResults[kMaxResults]; //stores a list of sql_data_t structures that
	  int resultLengths[kMaxResults];        //have been allocated but not released, together with their lengths.
						//the structure is {dataset 1, length 1, dataset 2, length 2 ...}
	  int numResults;	//number of stored results
};

void checkError(sql_data_t, Db_Query *);
void checkError(int, Db_Query *);
