/* ConnectionOrganization.cpp
 *
 * This class contains the method to organize unclassified packets
 * into connections.
 * This must be compiled with -L/usr/lib/mysql -lmysqlclient or it won't find
 * the mysql libraries.
 */
 
#include <cstdio>
#include <string.h>
#include <iostream>
#include <sstream>
#include <mysql/mysql.h>
#include <Db_Query/Db_Query.h>

#define host "localhost"
#define username "ulogd"
#define password "!*reSear"
#define database "ulogd"

#define SOURCE_IP_ADDRESS_FIELD_NUM 1
#define DESTINATION_IP_ADDRESS_FIELD_NUM 2
#define SOURCE_PORT_FIELD_NUM 3
#define DESTINATION_PORT_FIELD_NUM 4

using namespace std;

#include "ConnectionOrganization.h"
//class ConnectionOrganization {
//	void sortPackets();
//};


ConnectionOrganization::ConnectionOrganization(){
	// the query that checks for stale connections and closes them if they're old
	sprintf(timeoutstr, "update connections set currently_scored='NO', time_closed=time_last_packet, open='NO' where date_add(time_last_packet, interval %d minute) < now() and open='YES'",
		CONN_TIMEOUT);

	// query to fetch data from the packets (named: "ulog") table
			//       0           1          2        3          4          5   6            7       8
	strcpy(selectstr, "select oob_prefix, ip_saddr, ip_daddr, tcp_sport, tcp_dport, id, ip_protocol, ip_ttl, ip_totlen");
			//  9        10       11       12       13       14       15         16         17
	strcat(selectstr, ", tcp_urg, tcp_ack, tcp_psh, tcp_rst, tcp_syn, tcp_fin, udp_sport, udp_dport, udp_len");
			//     18             19
	strcat(selectstr, ", oob_time_sec, icmp_type from ulog order by oob_time_sec, oob_time_usec, id");

	// query to add a new non-UDP, non-ICMP (hopefully most of the time, TCP) connection
	strcpy(insertstr, "insert into connections set ip_saddr='%s', ip_daddr='%s', sport='%s', dport='%s'"); 
	strcat(insertstr, ", protocol='%s', packet_ttl='%s', packet_length='%s', tcp_urg='%s', tcp_ack='%s', tcp_psh='%s'");
	strcat(insertstr, ", tcp_rst='%s', tcp_syn='%s', tcp_fin='%s', time_last_packet=from_unixtime('%s')");
	strcat(insertstr, ", time_established=from_unixtime('%s'), num_packets=1"); 

	// query to update an existing non-UDP, non-ICMP connection
	strcpy(updatestr, "update connections set currently_scored='NO', num_packets=num_packets + 1");
	strcat(updatestr, ", protocol='%s', packet_ttl=(packet_ttl * num_packets + '%s')/(num_packets+1)");
	strcat(updatestr, ", packet_length=(packet_length * num_packets + '%s')/(num_packets+1)");
	strcat(updatestr, ", tcp_urg=tcp_urg+'%s', tcp_ack=tcp_ack+'%s', tcp_psh=tcp_psh+'%s'");
	strcat(updatestr, ", tcp_rst=tcp_rst+'%s', tcp_syn=tcp_syn+'%s', tcp_fin=tcp_fin+'%s', time_last_packet=from_unixtime('%s')");
	strcat(updatestr, " where connection_id='%s'");

	// query to add a new ICMP connection
	strcpy(icmp_insertstr, "insert into connections set ip_saddr='%s', ip_daddr='%s', protocol='%s', num_packets=1");
	strcat(icmp_insertstr, ", time_last_packet=from_unixtime('%s'), time_established=from_unixtime('%s')");

	// query to update an existing ICMP connection
	strcpy(icmp_updatestr, "update connections set currently_scored='NO', num_packets=num_packets +1, time_last_packet=from_unixtime('%s')  where connection_id='%s'");

	// query to add a new UDP connection
	strcpy(udp_insertstr, "insert into connections set ip_saddr='%s', ip_daddr='%s', sport='%s'");
	strcat(udp_insertstr, ", protocol='%s', packet_length='%s', num_packets=1");
	strcat(udp_insertstr, ", time_last_packet=from_unixtime('%s'), time_established=from_unixtime('%s')");

	// query to update an existing UDP connection
	strcpy(udp_updatestr, "update connections set currently_scored='NO', num_packets=num_packets+1");
	strcat(udp_updatestr, ", packet_length=(packet_length * num_packets + '%s')/(num_packets+1), time_last_packet=from_unixtime('%s')");
	strcat(udp_updatestr, " where connection_id='%s'");
}


void
ConnectionOrganization::sortPackets()
{
	Db_Query *dbhandle = new Db_Query;
	sql_data_t query_result;
	sql_data_t query_result2;
	int nrows, nfields;
	int nrows2, nfields2;
	char **row;
	char querystr[805];

	//Keep an eye on auto-incremented packet identification numbers
	sprintf(querystr, "select max(id) from ulog");
	checkError(query_result = dbhandle->query(querystr, strlen(querystr), &nrows, &nfields), dbhandle);
	if (atoll(*query_result) > MAX_AUTO_INCREMENT) {
		// if we're getting dangerously close to the maximum value of our packet identification
		// number, reset the id's to 0
		// (if we neglect to do this, then new packets won't get logged in the table)
		sprintf(querystr, "alter table ulog drop id");
		checkError(dbhandle->query(querystr, strlen(querystr)), dbhandle);
		sprintf(querystr, "alter table ulog add id int unsigned primary key auto_increment");
		checkError(dbhandle->query(querystr, strlen(querystr)), dbhandle);
	}
	dbhandle->release(query_result);

	//Close old connections
	checkError(dbhandle->query(timeoutstr, strlen(timeoutstr)), dbhandle);	

	//Get all packets
	checkError(query_result = dbhandle->query(selectstr, strlen(selectstr), &nrows, &nfields), dbhandle);
	
	for(int rowcnt = 0; rowcnt < nrows; rowcnt++){
		row = query_result + rowcnt * nfields; 
		if (!strcmp(row[6],"1")) { // ICMP packets
			sprintf(querystr, "select connection_id from connections where protocol=1 and ((ip_saddr='%s' and ip_daddr='%s' ) or (ip_saddr='%s' and ip_daddr='%s' )) and open='YES' and (time_last_packet + interval %d minute) >= from_unixtime('%s')", row[1], row[2], row[2], row[1], CONN_TIMEOUT, row[18]);
			checkError(query_result2 = dbhandle->query(querystr, strlen(querystr), &nrows2, &nfields2), dbhandle);
			if (nrows2 > 0) { // existing ICMP "connection"
				sprintf(querystr, icmp_updatestr, row[18], *query_result2);
			} else { // a new one
				if (strcmp(row[19],"0")) {
					sprintf(querystr, icmp_insertstr, row[1], row[2], row[6], row[18], row[18]);
				} else {
					continue;
				}
			}
			dbhandle->release(query_result2);
		} else if (!strcmp(row[6],"17")) { // UDP packets
			sprintf(querystr, "select connection_id from connections where sport='%s' and protocol=17 and ((ip_saddr='%s' and ip_daddr='%s') or (ip_saddr='%s' and ip_daddr='%s')) and open='YES' and (time_last_packet + interval %d minute) >= from_unixtime('%s')", row[15], row[1], row[2], row[2], row[1], CONN_TIMEOUT, row[18] );
			checkError(query_result2 = dbhandle->query(querystr, strlen(querystr), &nrows2, &nfields2), dbhandle);
			if (nrows2 > 0) { // existing UDP "connection"
                                sprintf(querystr, udp_updatestr, row[17], row[18], *query_result2);
                        } else { // a new one
                                sprintf(querystr, udp_insertstr, row[1], row[2], row[15], row[6], row[17], row[18], row[18]);
                        }
			dbhandle->release(query_result2);
		} else { // every other kind of packet; hopefully mostly TCP
			if(!strcmp(row[0],"NEW")) {  // if oob_prefix is set to "NEW" then add a new connection
				sprintf(querystr, "update connections set open='NO', time_closed=time_last_packet where (ip_saddr='%s' and ip_daddr='%s' and sport='%s' and dport='%s') or (ip_saddr='%s' and ip_daddr='%s' and sport='%s' and dport='%s') and open='YES'", 
						row[1], row[2], row[3], row[4], row[2], row[1], row[4], row[3]);

                	        checkError(query_result2 = dbhandle->query(querystr, strlen(querystr), &nrows2, &nfields2), dbhandle);
				dbhandle->release(query_result2);

				//create a new connection
				sprintf(querystr, insertstr, row[1], row[2], row[3], row[4], row[6], row[7], row[8], row[9], row[10],
					row[11], row[12], row[13], row[14], row[18], row[18]);

			} else {  //if not NEW, update the existing connection, or add a new one if none exists

				sprintf(querystr, "select connection_id from connections where (ip_saddr='%s' and ip_daddr='%s' and sport='%s' and dport='%s') or (ip_saddr='%s' and ip_daddr='%s' and sport='%s' and dport='%s') and open='YES' and (time_last_packet + interval %d minute) >= from_unixtime('%s')",
				row[1], row[2], row[3], row[4], row[2], row[1], row[4], row[3], CONN_TIMEOUT, row[18]);
 
				checkError(query_result2 = dbhandle->query(querystr, strlen(querystr), &nrows2, &nfields2), dbhandle);
				if (nrows2 > 0) {
					sprintf(querystr, updatestr, row[6], row[7], row[8], row[9], row[10], row[11], row[12], row[13],
						row[14], row[18], *query_result2);
							
				} else {
					sprintf(querystr, insertstr, row[1], row[2], row[3], row[4], row[6], row[7], row[8], row[9], row[10],
						row[11], row[12], row[13], row[14], row[18], row[18]);
				}
				dbhandle->release(query_result2);
			}
		}
                checkError(dbhandle->query(querystr, strlen(querystr)), dbhandle);

		sprintf(querystr, "delete from ulog where id='%s'", row[5]);
                checkError(dbhandle->query(querystr, strlen(querystr)), dbhandle);
	}
	delete dbhandle;
}
