/* Connection.cpp
 *
 * This class creates a Connection object from a mysql database row number.
 * This must be compiled with -L/usr/lib/mysql -lmysqlclient or it won't find
 * the mysql libraries.
 */
 
#include <cstdio>
#include <string.h>
#include <iostream>
#include <sstream>
#include <mysql/mysql.h>
#include <stdlib.h>

#ifndef CONNECTION
#define CONNECTION

#define host "localhost"
#define username "ulogd"
#define password "!*reSear"
#define database "ulogd"

#define SOURCE_IP_ADDRESS_FIELD_NUM 1
#define DESTINATION_IP_ADDRESS_FIELD_NUM 2
#define SOURCE_PORT_FIELD_NUM 3
#define DESTINATION_PORT_FIELD_NUM 4
#define PACKETS_FIELD_NUM 6
#define TIME_FIELD_NUM 7

#define SOURCE_IP_ADDRESS_FIELD_NUM_SQL 1
#define DESTINATION_IP_ADDRESS_FIELD_NUM_SQL 2
#define SOURCE_PORT_FIELD_NUM_SQL 3
#define DESTINATION_PORT_FIELD_NUM_SQL 4
#define SCORE_FIELD_NUM_SQL 5
#define OPEN_FIELD_NUM_SQL 6
#define PACKETS_FIELD_NUM_SQL 7
#define TIME_FIELD_NUM_SQL 8

using namespace std;

class Connection
{
	public:
	 int mysql_row_id;
	 unsigned int source_ip_address;
	 unsigned int destination_ip_address;
	 int source_port;
	 int destination_port;
	 double packets_per_second;
	 double score;
	 bool open;
	 int protocol;
	 double length_of_connection;
	 double packet_length;

//	 Connection(int);
	 Connection(unsigned int, unsigned int, int, int, double, bool, int, double, double, double);
};

Connection::Connection(unsigned int sIP, unsigned int dIP, int sPort, int dPort, double leScore, bool isOpen, int protoc, double len_of_connec, double pack_len, double packets)
{
	source_ip_address = sIP;
	destination_ip_address = dIP;
	source_port = sPort;
	destination_port = dPort;
	score = leScore;
	open = isOpen;
	packets_per_second = packets / len_of_connec;
	protocol = protoc;
	length_of_connection = len_of_connec;
	packet_length = pack_len;
}

/*
Connection::Connection(int mysql_id)
{
	MYSQL *conn;
	conn = mysql_init(NULL);
	mysql_real_connect(conn,host,username,password,database,0,NULL,0);
	
	MYSQL_RES *res_set;
	MYSQL_ROW row;

	char querystr[50];
	sprintf(querystr, "select * from connections where id=%i",mysql_id);
	cout << "Query: " << querystr << endl;
	mysql_query(conn,querystr);
	
	res_set = mysql_store_result(conn);
	
	if( (row = mysql_fetch_row(res_set)) ==  NULL )
	{
		cout << "Warning! No match found in database." << endl;
	} 
	else
	{
		source_ip_address = (int) row[SOURCE_IP_ADDRESS_FIELD_NUM];
		destination_ip_address = (int) row[DESTINATION_IP_ADDRESS_FIELD_NUM];
		source_port = (int) row[SOURCE_PORT_FIELD_NUM];
		destination_port = (int) row[DESTINATION_PORT_FIELD_NUM];
		mysql_row_id = mysql_id;
		packets_per_second = ((double) row[PACKETS_FIELD_NUM])/(int)row[TIME_FIELD_NUM];
	}
	mysql_close(conn);
}
*/

#endif
