using namespace std;

#include <iostream>
#include <cstdio>
//vector definition here http://www.sgi.com/tech/stl/Vector.html
#include <vector>
#include "Connection.cpp"
#include "Attributes/Attribute.cpp"

#define SAME_CONNECTION_DISTANCE .8
#define ANOMALY_DISTANCE .3
#define ANOMALY_SCORE .1

class Classifier
{
	//variables
	private:
	 vector<Attribute*> attributeList;
	 vector<Connection> connectionList;
	 double maxScore;	//note: this assumes all distance functions have max value 1

	//methods
	public:
	 int getConnectionsSize();
	 bool classify(Connection*, bool, bool);
	 Classifier(vector<Attribute*>, vector<Connection>, double);
	 Classifier(vector<Attribute*>, vector<Connection>);
	 Classifier(vector<Attribute*>);
};

Classifier::Classifier(vector<Attribute*> aList, vector<Connection> cList, double maximumScore)
{
	attributeList = aList;
	connectionList = cList;
	maxScore = maximumScore;
}

Classifier::Classifier(vector<Attribute*> aList, vector<Connection> cList)
{
	attributeList = aList;
	connectionList = cList;
}

Classifier::Classifier(vector<Attribute*> aList)
{
	attributeList = aList;
}

int Classifier::getConnectionsSize()
{
	return connectionList.size();
}

bool Classifier::classify(Connection *conn, bool addToConnectionList, bool changeScore)
{
	double distance;
	double minDistance = -1;
	Connection *minConnection;
	
	//cout<<"the number of stored connections is "<<connectionList.size()<<endl;
	for(unsigned int i = 0; i < connectionList.size(); ++i)
	{
		distance = 0;
		
		for(unsigned int j = 0; j < attributeList.size(); ++j)
		{
			distance += attributeList[j]->getWeight() * attributeList[j]->calculateDistance(*conn, connectionList[i]);
		}
		if(distance > minDistance || minDistance == -1)
		{
			minDistance = distance;
			minConnection = &connectionList[i];
		}
	}
	

	minDistance = minDistance/maxScore;
	
	// this checks to see if the connection is too far away from everything (it's anomalous) or if we have no 
	// connections in our database
	
	if(changeScore)
	{
		cout << endl << endl << "The current connection was initiated from "<<conn->source_ip_address<< " on port " << conn->source_port << " to destination "<<conn->destination_ip_address << " on port " << conn->destination_port<<endl;
	}

	// If we are supposed to score this connection
	if(changeScore)
	{
		// If the distance to the closest connection is less than a threshold
		if(minDistance < ANOMALY_DISTANCE || minDistance == -1)
		{
			cout<<"THIS CONNECTION IS ANOMALOUS."<<endl;
			conn->score = ANOMALY_SCORE;
		}
		// The distance to the closest connection is nearly 1, we should score them the same.
		else if (minDistance > SAME_CONNECTION_DISTANCE)
		{
			conn->score = minConnection->score;
			cout<<"This connection is close enough to be part of an existing cluster.  ";
			cout<<"If the score is close to the cluster's score, we won't add the connection to memory."<<endl;
		}
		else
			conn->score = (*minConnection).score * minDistance;
	}
	if(changeScore) {	
		cout << "The closest connection to the current connection was initiated from "<<minConnection->source_ip_address<< " on port " << minConnection->source_port << " to destination " << minConnection->destination_ip_address << " on port " << minConnection->destination_port<< ".  It received a score of "<<minConnection->score << "." << endl;
		cout << "The normalized distance from the closest connection to the current connection is "<<minDistance<<endl;
		cout << "Ergo, the current connection's new score is " << conn->score << endl;
	}
	// We only want to add it to the connection list if:
	// 1) We're not inside an existing cluster, OR
	// 2) We are inside an existing cluster, and our connection's score does
	// not match the score of the cluster at all well.
	if(addToConnectionList && (minDistance <= SAME_CONNECTION_DISTANCE || conn->score <= minConnection->score * SAME_CONNECTION_DISTANCE || minConnection->score <= conn->score * SAME_CONNECTION_DISTANCE))
	{
		connectionList.push_back(*conn);
	}
	
	return true;
}
