using namespace std;

#include <iostream>
#include "Connection.cpp"
#include "Attribute.cpp"

class Attr_SourceIP : public Attribute 
{
	public:
	 double calculateDistance(Connection, Connection);
	 Attr_SourceIP(double);
};

// This is going to simply return 1 if the IPs are the same, or
// 0 if the IPs are different, OR .5 if the IPs are in the same
// subnet.  Perhaps more could be done later, to do something
// "smarter" with "close" IPs.
double Attr_SourceIP::calculateDistance(Connection con1, Connection con2)
{

	if(con1.source_ip_address == con2.source_ip_address)
		return 1;
	// This presumes a source IP mask of 24 (i.e. 255.255.255.0)
	else if(con1.source_ip_address & (unsigned int)4294967040 ==
		con2.source_ip_address & (unsigned int)4294967040)
		return .5;
	else
		return 0;

	return 0.0;
}


Attr_SourceIP::Attr_SourceIP(double w)
{
	weight = w;
}

