using namespace std;

#include <iostream>
#include "Connection.cpp"
#include "Attribute.cpp"

class Attr_PacketsPerSecond : public Attribute
{
	public:
	 double calculateDistance(Connection, Connection);
	 Attr_PacketsPerSecond(double);
};

// This is going to return 1 if the packets per second are within 5%
// and .5 if the packets per second is >5% but <10%
double Attr_PacketsPerSecond::calculateDistance(Connection con1, Connection con2)
{
	if((con1.packets_per_second - con2.packets_per_second)/con1.packets_per_second <.05 ||
	   (con1.packets_per_second - con2.packets_per_second)/con2.packets_per_second <.05)
	{
		return 1;
	}
	else if((con1.packets_per_second - con2.packets_per_second)/con1.packets_per_second <.1 ||
		(con1.packets_per_second - con2.packets_per_second)/con2.packets_per_second <.1)
	{
		return .5;
	}
	else
	{
		return 0;
	}
}

Attr_PacketsPerSecond::Attr_PacketsPerSecond(double w)
{
	weight = w;
}
