using namespace std;

#include <iostream>
#include "Connection.cpp"
#include "Attribute.cpp"

class Attr_PacketLength : public Attribute
{
        public:
         double calculateDistance(Connection, Connection);
	 Attr_PacketLength (double);
};


// This is going to return 1 if the packets per second are within 5%
// and .5 if the packets per second is >5% but <10%
double Attr_PacketLength::calculateDistance(Connection con1, Connection con2)
{
	if((con1.packet_length - con2.packet_length)/con1.packet_length <.05 ||
	   (con1.packet_length - con2.packet_length)/con2.packet_length <.05)
	{
		return 1;
	}
	else if((con1.packet_length - con2.packet_length)/con1.packet_length <.1 ||
		(con1.packet_length - con2.packet_length)/con2.packet_length <.1)
	{
		return .5;
	}
	else
	{
		return 0;
	}
}

Attr_PacketLength::Attr_PacketLength(double w)
{
	weight = w;
}
